
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
honeypots = m.addVar(vtype=GRB.INTEGER, name="honeypots")
network_administrators = m.addVar(vtype=GRB.INTEGER, name="network_administrators")
patches_per_day = m.addVar(vtype=GRB.INTEGER, name="patches_per_day")

# Objective function
m.setObjective(2.27 * honeypots + 8.46 * network_administrators + 3.88 * patches_per_day, GRB.MAXIMIZE)

# Constraints
# Data accessibility impact constraint
m.addConstr(12 * honeypots + 18 * network_administrators + 12 * patches_per_day <= 265, "data_accessibility")

# Network integrity impact constraint
m.addConstr(20 * honeypots + 20 * network_administrators + 4 * patches_per_day <= 131, "network_integrity")

# Power consumption constraint
m.addConstr(20 * honeypots + 12 * network_administrators + 12 * patches_per_day <= 115, "power_consumption")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Honeypots: {honeypots.x}")
    print(f"Network Administrators: {network_administrators.x}")
    print(f"Patches per Day: {patches_per_day.x}")
else:
    print("No optimal solution found")
