
from gurobipy import Model, GRB

# Create a new model
model = Model("nutrition_optimization")

# Create variables
corn_cobs = model.addVar(vtype=GRB.INTEGER, name="corn_cobs")
chicken_breasts = model.addVar(vtype=GRB.INTEGER, name="chicken_breasts")

# Set objective function
model.setObjective(3 * corn_cobs + 7 * chicken_breasts, GRB.MINIMIZE)

# Add constraints
model.addConstr(17 * corn_cobs + 4 * chicken_breasts >= 16, "fat_constraint1")
model.addConstr(22 * corn_cobs + 18 * chicken_breasts >= 52, "carbohydrate_constraint1")
model.addConstr(-7 * corn_cobs + 10 * chicken_breasts >= 0, "combined_constraint")
model.addConstr(17 * corn_cobs + 4 * chicken_breasts <= 69, "fat_constraint2")  # Corrected upper bound
model.addConstr(22 * corn_cobs + 18 * chicken_breasts <= 210, "carbohydrate_constraint2") # Corrected upper bound


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Corn cobs: {corn_cobs.x}")
    print(f"Chicken breasts: {chicken_breasts.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

