
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="corn_cobs")
x1 = m.addVar(vtype=GRB.INTEGER, name="chicken_breasts")

# Objective function: Minimize 3*x0 + 7*x1
m.setObjective(3*x0 + 7*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(17*x0 + 4*x1 >= 16, "min_fat")
m.addConstr(22*x0 + 18*x1 >= 52, "min_carbohydrates")
m.addConstr(-7*x0 + 10*x1 >= 0, "custom_constraint")
m.addConstr(17*x0 + 4*x1 <= 69, "max_fat")
m.addConstr(22*x0 + 18*x1 <= 210, "max_carbohydrates")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Corn cobs:", x0.x)
    print("Chicken breasts:", x1.x)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found. Status:", m.status)
