
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
corn_cobs = m.addVar(name="corn_cobs", integer=True, lb=0)
chicken_breasts = m.addVar(name="chicken_breasts", integer=True, lb=0)

# Objective function: Minimize 3*corn_cobs + 7*chicken_breasts
m.setObjective(3 * corn_cobs + 7 * chicken_breasts, gp.GRB.MINIMIZE)

# Constraints
# Fat constraints
m.addConstr(17 * corn_cobs + 4 * chicken_breasts >= 16, name="min_fat")
m.addConstr(17 * corn_cobs + 4 * chicken_breasts <= 69, name="max_fat")

# Carbohydrates constraints
m.addConstr(22 * corn_cobs + 18 * chicken_breasts >= 52, name="min_carbohydrates")
m.addConstr(22 * corn_cobs + 18 * chicken_breasts <= 210, name="max_carbohydrates")

# Linear constraint
m.addConstr(-7 * corn_cobs + 10 * chicken_breasts >= 0, name="linear_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Corn Cobs: {corn_cobs.varValue}")
    print(f"Chicken Breasts: {chicken_breasts.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("The model is infeasible.")
