
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
ringo_hours = m.addVar(lb=0, name="ringo_hours")
paul_hours = m.addVar(lb=0, name="paul_hours")

# Set objective function
m.setObjective(9 * ringo_hours + 3 * paul_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * ringo_hours + 1 * paul_hours >= 22, "computer_competence_min")
m.addConstr(9 * ringo_hours + 1 * paul_hours >= 9, "productivity_min")
m.addConstr(5 * ringo_hours + 3 * paul_hours >= 28, "paperwork_competence_min")
m.addConstr(3 * ringo_hours + 4 * paul_hours >= 10, "likelihood_to_quit_min")

m.addConstr(-5 * ringo_hours + 10 * paul_hours >= 0, "custom_constraint")

m.addConstr(4 * ringo_hours + 1 * paul_hours <= 36, "computer_competence_max")
m.addConstr(9 * ringo_hours + 1 * paul_hours <= 35, "productivity_max")
m.addConstr(5 * ringo_hours + 3 * paul_hours <= 38, "paperwork_competence_max")
m.addConstr(3 * ringo_hours + 4 * paul_hours <= 34, "likelihood_to_quit_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: {m.objVal}")
    print(f"Ringo hours: {ringo_hours.x}")
    print(f"Paul hours: {paul_hours.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

