
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
Ringo_hours = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="Ringo_hours")
Paul_hours = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="Paul_hours")

# Define the objective function
m.setObjective(9 * Ringo_hours + 3 * Paul_hours, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * Ringo_hours + 1 * Paul_hours >= 22, "Computer_Rating_Min")
m.addConstr(9 * Ringo_hours + 1 * Paul_hours >= 9, "Productivity_Rating_Min")
m.addConstr(5 * Ringo_hours + 3 * Paul_hours >= 28, "Paperwork_Rating_Min")
m.addConstr(3 * Ringo_hours + 4 * Paul_hours >= 10, "Quit_Index_Min")
m.addConstr(-5 * Ringo_hours + 10 * Paul_hours >= 0, "Custom_Constraint")

m.addConstr(4 * Ringo_hours + 1 * Paul_hours <= 36, "Computer_Rating_Max")
m.addConstr(9 * Ringo_hours + 1 * Paul_hours <= 35, "Productivity_Rating_Max")
m.addConstr(5 * Ringo_hours + 3 * Paul_hours <= 38, "Paperwork_Rating_Max")
m.addConstr(3 * Ringo_hours + 4 * Paul_hours <= 34, "Quit_Index_Max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Ringo hours: {Ringo_hours.x}")
    print(f"Paul hours: {Paul_hours.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
