
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    ringo_hours = model.addVar(name="Ringo_hours", lb=0, ub=None)  # Assuming non-negative hours
    paul_hours = model.addVar(name="Paul_hours", lb=0, ub=None)  # Assuming non-negative hours

    # Objective function
    model.setObjective(9 * ringo_hours + 3 * paul_hours, gurobi.GRB.MAXIMIZE)

    # Attribute values
    r0_ringo = 4
    r1_ringo = 9
    r2_ringo = 5
    r3_ringo = 3
    r0_paul = 1
    r1_paul = 1
    r2_paul = 3
    r3_paul = 4

    # Combined constraints
    model.addConstr(r0_ringo * ringo_hours + r0_paul * paul_hours >= 22, name="computer_competence_min")
    model.addConstr(r0_ringo * ringo_hours + r0_paul * paul_hours <= 36, name="computer_competence_max")

    model.addConstr(r1_ringo * ringo_hours + r1_paul * paul_hours >= 9, name="productivity_min")
    model.addConstr(r1_ringo * ringo_hours + r1_paul * paul_hours <= 35, name="productivity_max")

    model.addConstr(r2_ringo * ringo_hours + r2_paul * paul_hours >= 28, name="paperwork_competence_min")
    model.addConstr(r2_ringo * ringo_hours + r2_paul * paul_hours <= 38, name="paperwork_competence_max")

    model.addConstr(r3_ringo * ringo_hours + r3_paul * paul_hours >= 10, name="likelihood_to_quit_min")
    model.addConstr(r3_ringo * ringo_hours + r3_paul * paul_hours <= 34, name="likelihood_to_quit_max")

    model.addConstr(-5 * ringo_hours + 10 * paul_hours >= 0, name="hours_worked_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal hours for Ringo: {ringo_hours.varValue}")
        print(f"Optimal hours for Paul: {paul_hours.varValue}")
        print(f"Optimal objective value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

optimization_problem()
