
import gurobipy as gp

# Create a new model
m = gp.Model("sustainability_optimization")

# Create variables
diapers = m.addVar(vtype=gp.GRB.INTEGER, name="diapers")
toilet_paper = m.addVar(vtype=gp.GRB.INTEGER, name="toilet_paper")
candles = m.addVar(vtype=gp.GRB.INTEGER, name="candles")
rubber_gloves = m.addVar(vtype=gp.GRB.INTEGER, name="rubber_gloves")
dish_soap = m.addVar(vtype=gp.GRB.INTEGER, name="dish_soap")

# Set objective function
m.setObjective(2 * diapers + 5 * toilet_paper + 8 * candles + 6 * rubber_gloves + 5 * dish_soap, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * toilet_paper + 11 * candles >= 26, "c1")
m.addConstr(3 * diapers + 11 * rubber_gloves >= 43, "c2")
m.addConstr(11 * candles + 11 * rubber_gloves >= 16, "c3")
m.addConstr(11 * candles + 12 * dish_soap >= 39, "c4")
m.addConstr(2 * toilet_paper + 12 * dish_soap >= 31, "c5")
m.addConstr(2 * toilet_paper + 11 * rubber_gloves >= 40, "c6")
m.addConstr(3 * diapers + 2 * toilet_paper >= 20, "c7")
m.addConstr(2 * toilet_paper + 11 * candles <= 121, "c8")
m.addConstr(3 * diapers + 2 * toilet_paper <= 100, "c9")
m.addConstr(3 * diapers + 11 * candles <= 62, "c10")
m.addConstr(3 * diapers + 2 * toilet_paper + 11 * rubber_gloves <= 88, "c11")
m.addConstr(3 * diapers + 11 * rubber_gloves + 12 * dish_soap <= 179, "c12")
m.addConstr(3 * diapers + 2 * toilet_paper + 12 * dish_soap <= 69, "c13")
m.addConstr(3 * diapers + 2 * toilet_paper + 11 * candles <= 152, "c14")
m.addConstr(2 * toilet_paper + 11 * candles + 12 * dish_soap <= 150, "c15")
m.addConstr(3 * diapers + 2 * toilet_paper + 11 * candles + 11 * rubber_gloves + 12 * dish_soap <= 150, "c16")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

