
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
d = m.addVar(vtype=GRB.INTEGER, name="diapers")
t = m.addVar(vtype=GRB.INTEGER, name="toilet_paper_rolls")
c = m.addVar(vtype=GRB.INTEGER, name="candles")
r = m.addVar(vtype=GRB.INTEGER, name="rubber_gloves")
s = m.addVar(vtype=GRB.INTEGER, name="dish_soap_bottles")

# Objective function
m.setObjective(2*d + 5*t + 8*c + 6*r + 5*s, GRB.MAXIMIZE)

# Constraints
# Minimum sustainability scores for combinations of items
m.addConstr(2*t + 11*c >= 26)
m.addConstr(3*d + 11*r >= 43)
m.addConstr(11*c + 11*r >= 16)
m.addConstr(11*c + 12*s >= 39)
m.addConstr(2*t + 12*s >= 31)
m.addConstr(2*t + 11*r >= 40)
m.addConstr(3*d + 2*t >= 20)

# Maximum sustainability scores for combinations of items
m.addConstr(2*t + 11*c <= 121)
m.addConstr(3*d + 2*t <= 100)
m.addConstr(3*d + 11*c <= 62)
m.addConstr(3*d + 2*t + 11*r <= 88)
m.addConstr(3*d + 11*r + 12*s <= 179)
m.addConstr(3*d + 2*t + 12*s <= 69)
m.addConstr(3*d + 2*t + 11*c <= 152)
m.addConstr(2*t + 11*c + 12*s <= 150)
m.addConstr(3*d + 2*t + 11*c + 11*r + 12*s <= 216)

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Diapers: {d.x}")
    print(f"Toilet paper rolls: {t.x}")
    print(f"Candles: {c.x}")
    print(f"Rubber gloves: {r.x}")
    print(f"Dish soap bottles: {s.x}")
else:
    print("No optimal solution found")
