
import gurobi

def optimize():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    diapers = model.addVar(name="diapers", vtype=gurobi.GRB.INTEGER)
    toilet_paper_rolls = model.addVar(name="toilet_paper_rolls", vtype=gurobi.GRB.INTEGER)
    candles = model.addVar(name="candles", vtype=gurobi.GRB.INTEGER)
    rubber_gloves = model.addVar(name="rubber_gloves", vtype=gurobi.GRB.INTEGER)
    dish_soap_bottles = model.addVar(name="dish_soap_bottles", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(2 * diapers + 5 * toilet_paper_rolls + 8 * candles + 6 * rubber_gloves + 5 * dish_soap_bottles, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(2 * toilet_paper_rolls + 11 * candles >= 26)
    model.addConstr(3 * diapers + 11 * rubber_gloves >= 43)
    model.addConstr(11 * candles + 11 * rubber_gloves >= 16)
    model.addConstr(11 * candles + 12 * dish_soap_bottles >= 39)
    model.addConstr(2 * toilet_paper_rolls + 12 * dish_soap_bottles >= 31)
    model.addConstr(2 * toilet_paper_rolls + 11 * rubber_gloves >= 40)
    model.addConstr(3 * diapers + 2 * toilet_paper_rolls >= 20)
    model.addConstr(3 * diapers + 2 * toilet_paper_rolls <= 100)
    model.addConstr(3 * diapers + 11 * candles <= 62)
    model.addConstr(3 * diapers + 2 * toilet_paper_rolls + 11 * rubber_gloves <= 88)
    model.addConstr(3 * diapers + 11 * rubber_gloves + 12 * dish_soap_bottles <= 179)
    model.addConstr(3 * diapers + 2 * toilet_paper_rolls + 12 * dish_soap_bottles <= 69)
    model.addConstr(3 * diapers + 2 * toilet_paper_rolls + 11 * candles <= 152)
    model.addConstr(2 * toilet_paper_rolls + 11 * candles + 12 * dish_soap_bottles <= 150)
    model.addConstr(3 * diapers + 2 * toilet_paper_rolls + 11 * candles + 11 * rubber_gloves + 12 * dish_soap_bottles <= 150)
    model.addConstr(2 * toilet_paper_rolls + 11 * candles <= 121)

    # Set the upper bound for the sustainability score
    model.addConstr(3 * diapers + 2 * toilet_paper_rolls + 11 * candles + 11 * rubber_gloves + 12 * dish_soap_bottles <= 216)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Diapers: ", diapers.varValue)
        print("Toilet Paper Rolls: ", toilet_paper_rolls.varValue)
        print("Candles: ", candles.varValue)
        print("Rubber Gloves: ", rubber_gloves.varValue)
        print("Dish Soap Bottles: ", dish_soap_bottles.varValue)
    else:
        print("The model is infeasible")

optimize()
