
from gurobipy import *

try:
    # Create a new model
    model = Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apple_pies")
    x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cornichons")
    x2 = model.addVar(lb=0, vtype=GRB.INTEGER, name="protein_bars")
    x3 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="slices_of_pizza")

    # Set objective function
    model.setObjective(9*x0*x0 + 3*x0*x1 + x0*x3 + 8*x1*x2 + x2*x2 + 9*x3*x3 + 7*x1 + 3*x2 + 2*x3, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(10*x0 + 10*x1 + 9*x2 + 9*x3 <= 115, "protein_constraint") # r0
    model.addConstr(8*x0 + 11*x1 + 7*x2 + 6*x3 <= 96, "cost_constraint") # r1
    model.addConstr(5*x0 + 4*x1 + 4*x2 + x3 <= 102, "healthiness_constraint") # r2
    model.addConstr(x2*x2 + x3*x3 >= 14, "protein_constraint_1")
    model.addConstr(10*x1 + 9*x2 + 9*x3 >= 14, "protein_constraint_2")
    model.addConstr(10*x0 + 9*x2 + 9*x3 >= 14, "protein_constraint_3")
    model.addConstr(10*x0 + 10*x1 + 9*x3 >= 14, "protein_constraint_4")
    model.addConstr(10*x1 + 9*x2 + 9*x3 >= 21, "protein_constraint_5")
    model.addConstr(10*x0 + 9*x2 + 9*x3 >= 21, "protein_constraint_6")
    model.addConstr(10*x0 + 10*x1 + 9*x3 >= 21, "protein_constraint_7")
    model.addConstr(10*x1 + 9*x2 + 9*x3 >= 21, "protein_constraint_8")
    model.addConstr(10*x0 + 9*x2 + 9*x3 >= 21, "protein_constraint_9")
    model.addConstr(10*x0 + 10*x1 + 9*x3 >= 21, "protein_constraint_10")
    model.addConstr(7*x2*x2 + 6*x3*x3 >= 19, "cost_constraint_1")
    model.addConstr(8*x0 + 7*x2 >= 14, "cost_constraint_2")
    model.addConstr(11*x1 + 7*x2 + 6*x3 >= 21, "cost_constraint_3")
    model.addConstr(4*x2 + x3 >= 13, "healthiness_constraint_1")
    model.addConstr(100*x1*x1 + 81*x3*x3 <= 56, "protein_constraint_11") # squared protein values
    model.addConstr(10*x0 + 10*x1 <= 63, "protein_constraint_12")
    model.addConstr(100*x1*x1 + 81*x2*x2 <= 53, "protein_constraint_13") # squared protein values
    model.addConstr(10*x0 + 10*x1 + 9*x2 + 9*x3 <= 53, "protein_constraint_14")
    model.addConstr(8*x0 + 7*x2 <= 77, "cost_constraint_4")
    model.addConstr(11*x1 + 6*x3 <= 28, "cost_constraint_5")
    model.addConstr(64*x0*x0 + 121*x1*x1 <= 58, "cost_constraint_6") # squared cost values
    model.addConstr(49*x2*x2 + 36*x3*x3 <= 81, "cost_constraint_7") # squared cost values
    model.addConstr(8*x0 + 11*x1 + 7*x2 + 6*x3 <= 81, "cost_constraint_8")
    model.addConstr(4*x1 + 4*x2 <= 78, "healthiness_constraint_2")
    model.addConstr(4*x2 + x3 <= 43, "healthiness_constraint_3")
    model.addConstr(5*x0 + x3 <= 63, "healthiness_constraint_4")
    model.addConstr(4*x1 + x3 <= 25, "healthiness_constraint_5")
    model.addConstr(25*x0*x0 + 16*x2*x2 <= 85, "healthiness_constraint_6") # squared healthiness values
    model.addConstr(25*x0*x0 + 16*x2*x2 + x3*x3 <= 68, "healthiness_constraint_7") # squared healthiness values
    model.addConstr(4*x1 + 4*x2 + x3 <= 65, "healthiness_constraint_8")
    model.addConstr(25*x0*x0 + 16*x1*x1 + x3*x3 <= 71, "healthiness_constraint_9") # squared healthiness values
    model.addConstr(5*x0 + 4*x1 + 4*x2 + x3 <= 71, "healthiness_constraint_10")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Vars:')
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")

except GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
