
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="apple_pies", lb=0)  # Non-integer amount allowed
x1 = m.addVar(name="cornichons", lb=0)  # Non-integer amount allowed
x2 = m.addVar(name="protein_bars", lb=0, integrality=gp.GRB.INTEGER)  # Integer amount required
x3 = m.addVar(name="slices_of_pizza", lb=0)  # Non-integer amount allowed

# Objective function
m.setObjective(9*x0**2 + 3*x0*x1 + x0*x3 + 8*x1*x2 + x2**2 + 9*x3**2 + 7*x1 + 3*x2 + 2*x3, gp.GRB.MAXIMIZE)

# Constraints
# Protein constraints
m.addConstr(10*x0 + 10*x1 + 9*x2 + 9*x3 >= 14)
m.addConstr(10*x1 + 9*x2 + 9*x3 >= 14)
m.addConstr(10*x0 + 9*x2 + 9*x3 >= 14)
m.addConstr(10*x0 + 10*x1 + 9*x3 >= 14)
m.addConstr(10*x1 + 9*x2 + 9*x3 >= 21)
m.addConstr(10*x0 + 9*x2 + 9*x3 >= 21)
m.addConstr(10*x0 + 10*x1 + 9*x3 >= 21)
m.addConstr(10*x1 + 9*x2 + 9*x3 >= 21)
m.addConstr(10*x0 + 9*x2 + 9*x3 >= 21)
m.addConstr(10*x0 + 10*x1 + 9*x3 >= 21)

# Cost constraints
m.addConstr(7*x2**2 + 6*x3**2 >= 19)
m.addConstr(8*x0 + 7*x2 >= 14)
m.addConstr(11*x1 + 7*x2 + 6*x3 >= 21)
m.addConstr(8*x0 + 11*x1 <= 77)
m.addConstr(11*x1 + 6*x3 <= 28)
m.addConstr(8**2*x0**2 + 11**2*x1**2 <= 58)
m.addConstr(7**2*x2**2 + 6**2*x3**2 <= 81)
m.addConstr(8*x0 + 11*x1 + 7*x2 + 6*x3 <= 81)

# Healthiness rating constraints
m.addConstr(4*x2 + x3 >= 13)
m.addConstr(4*x1 + 4*x2 <= 78)
m.addConstr(4*x2 + x3 <= 43)
m.addConstr(5*x0 + x3 <= 63)
m.addConstr(4*x1 + x3 <= 25)
m.addConstr(5**2*x0**2 + 4**2*x2**2 <= 85)
m.addConstr(5**2*x0**2 + 4**2*x2**2 + x3**2 <= 68)
m.addConstr(4*x1 + 4*x2 + x3 <= 65)
m.addConstr(5**2*x0**2 + 4**2*x1**2 + x3**2 <= 71)
m.addConstr(5*x0 + 4*x1 + 4*x2 + x3 <= 71)

# Protein squares constraints
m.addConstr(9**2*x2**2 + 9**2*x3**2 <= 56)
m.addConstr(10**2*x0**2 + 10**2*x1**2 <= 63)
m.addConstr(10**2*x1**2 + 9**2*x2**2 <= 53)
m.addConstr(10*x0 + 10*x1 + 9*x2 + 9*x3 <= 53)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Apple pies: ", x0.varValue)
    print("Cornichons: ", x1.varValue)
    print("Protein bars: ", x2.varValue)
    print("Slices of pizza: ", x3.varValue)
else:
    print("The model is infeasible")
