
from gurobipy import Model, GRB

# Create a new model
model = Model("Work_Optimization")

# Create variables
ringo_hours = model.addVar(vtype=GRB.INTEGER, name="ringo_hours")
jean_hours = model.addVar(vtype=GRB.INTEGER, name="jean_hours")
dale_hours = model.addVar(vtype=GRB.CONTINUOUS, name="dale_hours")

# Set objective function
model.setObjective(9.57 * ringo_hours + 1.98 * jean_hours + 9.91 * dale_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(6 * ringo_hours + 2 * jean_hours >= 37, "c1")
model.addConstr(16 * ringo_hours + 16 * dale_hours >= 7, "c2")
model.addConstr(7 * jean_hours + 16 * dale_hours >= 9, "c3")
model.addConstr(2 * jean_hours + 8 * dale_hours <= 79, "c4")
model.addConstr(6 * ringo_hours + 2 * jean_hours <= 117, "c5")
model.addConstr(6 * ringo_hours + 8 * dale_hours <= 88, "c6")
model.addConstr(6 * ringo_hours + 2 * jean_hours + 8 * dale_hours <= 88, "c7")
model.addConstr(7 * jean_hours + 16 * dale_hours <= 26, "c8")
model.addConstr(16 * ringo_hours + 16 * dale_hours <= 34, "c9")
model.addConstr(16 * ringo_hours + 7 * jean_hours + 16 * dale_hours <= 34, "c10")


# Resource Constraints (implied but added for clarity)
model.addConstr(6 * ringo_hours + 2 * jean_hours + 8 * dale_hours <= 132, "r0") # Organization Score
model.addConstr(16 * ringo_hours + 7 * jean_hours + 16 * dale_hours <= 40, "r1") # Work Quality Rating


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Ringo Hours: %g' % ringo_hours.x)
    print('Jean Hours: %g' % jean_hours.x)
    print('Dale Hours: %g' % dale_hours.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % model.status)

