
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
hours_Ringo = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Ringo")
hours_Jean = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Jean")
hours_Dale = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Dale")

# Objective function
m.setObjective(9.57 * hours_Ringo + 1.98 * hours_Jean + 9.91 * hours_Dale, GRB.MAXIMIZE)

# Constraints
m.addConstr(6 * hours_Ringo + 2 * hours_Jean >= 37, name="org_score_Ringo_Jean_min")
m.addConstr(16 * hours_Ringo + 16 * hours_Dale >= 7, name="work_quality_Ringo_Dale_min")
m.addConstr(7 * hours_Jean + 16 * hours_Dale >= 9, name="work_quality_Jean_Dale_min")

m.addConstr(2 * hours_Jean + 8 * hours_Dale <= 79, name="org_score_Jean_Dale_max")
m.addConstr(6 * hours_Ringo + 2 * hours_Jean <= 117, name="org_score_Ringo_Jean_max")
m.addConstr(6 * hours_Ringo + 8 * hours_Dale <= 88, name="org_score_Ringo_Dale_max")
m.addConstr(6 * hours_Ringo + 2 * hours_Jean + 8 * hours_Dale <= 88, name="total_org_score_max")

m.addConstr(7 * hours_Jean + 16 * hours_Dale <= 26, name="work_quality_Jean_Dale_max")
m.addConstr(16 * hours_Ringo + 16 * hours_Dale <= 34, name="work_quality_Ringo_Dale_max")
m.addConstr(16 * hours_Ringo + 7 * hours_Jean + 16 * hours_Dale <= 34, name="total_work_quality_max")

# Solve the model
m.optimize()

