
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    R = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="Ringo_hours")
    J = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="Jean_hours")
    D = model.addVar(lb=0, name="Dale_hours")

    # Define the objective function
    model.setObjective(9.57 * R + 1.98 * J + 9.91 * D, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(6 * R + 2 * J + 8 * D <= 132, name="organization_score")
    model.addConstr(16 * R + 7 * J + 16 * D <= 40, name="work_quality_rating")

    model.addConstr(6 * R + 2 * J >= 37, name="combined_organization_score_RJ")
    model.addConstr(16 * R + 16 * D >= 7, name="combined_work_quality_rating_RD")
    model.addConstr(7 * J + 16 * D >= 9, name="combined_work_quality_rating_JD")

    model.addConstr(2 * J + 8 * D <= 79, name="combined_organization_score_JD")
    model.addConstr(6 * R + 2 * J <= 117, name="combined_organization_score_RJ")
    model.addConstr(6 * R + 8 * D <= 88, name="combined_organization_score_RD")
    model.addConstr(6 * R + 2 * J + 8 * D <= 88, name="combined_organization_score_RJD")

    model.addConstr(7 * J + 16 * D <= 26, name="combined_work_quality_rating_JD")
    model.addConstr(16 * R + 16 * D <= 34, name="combined_work_quality_rating_RD")
    model.addConstr(16 * R + 7 * J + 16 * D <= 34, name="combined_work_quality_rating_RJD")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Ringo hours: {R.varValue}")
        print(f"Jean hours: {J.varValue}")
        print(f"Dale hours: {D.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
