
from gurobipy import Model, GRB

# Create a new model
m = Model("resource_allocation")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="air_defense_batteries")
x1 = m.addVar(vtype=GRB.INTEGER, name="medical_platoons")
x2 = m.addVar(vtype=GRB.INTEGER, name="reconnaissance_troops")

# Set objective function
m.setObjective(x0**2 + 5*x0*x2 + 4*x1**2 + 5*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(24.81*x1 + 14.26*x2 >= 147, "mobility_constraint1")
m.addConstr(7.23*x0 + 24.81*x1 + 14.26*x2 >= 147, "mobility_constraint2")
m.addConstr(12.68*x0**2 + 11.12*x2**2 >= 90, "fun_constraint1")
m.addConstr(12.68*x0 + 22.6*x1 >= 73, "fun_constraint2")
m.addConstr(12.68*x0 + 22.6*x1 + 11.12*x2 >= 73, "fun_constraint3")
m.addConstr(x0 - 7*x1 >= 0, "quantity_constraint")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('x0: %g' % x0.x)
    print('x1: %g' % x1.x)
    print('x2: %g' % x2.x)
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

