
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="air_defense_batteries")
x1 = m.addVar(vtype=GRB.INTEGER, name="medical_platoons")
x2 = m.addVar(vtype=GRB.INTEGER, name="reconnaissance_troops")

# Objective function
m.setObjective(1*x0**2 + 5*x0*x2 + 4*x1**2 + 5*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(7.23*x0 + 24.81*x1 + 14.26*x2 >= 147, name="total_mobility")
m.addConstr(24.81*x1 + 14.26*x2 >= 147, name="mobility_med_recon")
m.addConstr(12.68*x0 + 22.6*x1 >= 73, name="fun_factor_air_med")
m.addConstr(12.68*x0 + 11.12*x2 >= 90, name="fun_factor_air_recon") # Assuming linear for simplicity
m.addConstr(12.68*x0 + 22.6*x1 + 11.12*x2 >= 73, name="total_fun_factor")
m.addConstr(x0 - 7*x1 >= 0, name="linear_inequality")

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print(f"Objective: {m.objVal}")
