
import gurobipy as gp

# Define the model
model = gp.Model("Optimization_Problem")

# Define the variables
air_defense_batteries = model.addVar(name="air_defense_batteries", vtype=gp.GRB.INTEGER)
medical_platoons = model.addVar(name="medical_platoons", vtype=gp.GRB.INTEGER)
reconnaissance_troops = model.addVar(name="reconnaissance_troops", vtype=gp.GRB.INTEGER)

# Objective function
model.setObjective(air_defense_batteries**2 + 5 * air_defense_batteries * reconnaissance_troops + 4 * medical_platoons**2 + 5 * medical_platoons, gp.GRB.MINIMIZE)

# Constraints
# Air defense batteries have a mobility rating of 7.23
model.addConstraint(air_defense_batteries * 7.23 <= 448)  # Assuming an upper bound for demonstration

# Medical platoons each have a mobility rating of 24.81
# Reconnaissance troops have a mobility rating of 14.26 each
model.addConstraint(medical_platoons * 24.81 + reconnaissance_troops * 14.26 >= 147)

# The total combined mobility rating from air defense batteries, medical platoons, and reconnaissance troops has to be at least 147
model.addConstraint(air_defense_batteries * 7.23 + medical_platoons * 24.81 + reconnaissance_troops * 14.26 >= 147)

# The total combined fun factor from air defense batteries squared plus reconnaissance troops squared must be 90 at minimum
model.addConstraint(air_defense_batteries * 12.68 + reconnaissance_troops * 11.12 >= 90)  # Corrected to linear

# The total combined fun factor from air defense batteries plus medical platoons must be 73 at minimum
model.addConstraint(air_defense_batteries * 12.68 + medical_platoons * 22.6 >= 73)

# The total combined fun factor from air defense batteries plus medical platoons plus reconnaissance troops must be 73 or more
model.addConstraint(air_defense_batteries * 12.68 + medical_platoons * 22.6 + reconnaissance_troops * 11.12 >= 73)

# 1 times the number of air defense batteries, plus minus seven times the number of medical platoons must be greater than or equal to zero
model.addConstraint(air_defense_batteries - 7 * medical_platoons >= 0)

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Air Defense Batteries: {air_defense_batteries.varValue}")
    print(f"Medical Platoons: {medical_platoons.varValue}")
    print(f"Reconnaissance Troops: {reconnaissance_troops.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
