
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x0 = m.addVar(name="milligrams of vitamin B3", lb=-gp.GRB.INFINITY)
x1 = m.addVar(name="milligrams of iron", lb=-gp.GRB.INFINITY)
x2 = m.addVar(name="milligrams of vitamin D", lb=-gp.GRB.INFINITY)
x3 = m.addVar(name="milligrams of calcium", lb=-gp.GRB.INFINITY)

# Objective function
m.setObjective(5.81*x0 + 1.67*x1 + 7.59*x2 + 7.7*x3, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(16*x0 <= 522)
m.addConstr(33*x0 <= 300)
m.addConstr(27*x0 <= 175)
m.addConstr(34*x1 <= 522)
m.addConstr(20*x1 <= 300)
m.addConstr(7*x1 <= 175)
m.addConstr(9*x2 <= 522)
m.addConstr(34*x2 <= 300)
m.addConstr(34*x2 <= 175)
m.addConstr(18*x3 <= 522)
m.addConstr(30*x3 <= 300)
m.addConstr(4*x3 <= 175)

m.addConstr(16*x0 + 9*x2 >= 50)
m.addConstr(16*x0 + 18*x3 >= 49)
m.addConstr(16*x0 + 34*x1 >= 72)
m.addConstr(34*x1 + 9*x2 >= 128)
m.addConstr(16*x0 + 9*x2 + 18*x3 >= 109)
m.addConstr(34*x1 + 9*x2 + 18*x3 >= 109)
m.addConstr(16*x0 + 9*x2 + 18*x3 >= 79)
m.addConstr(34*x1 + 9*x2 + 18*x3 >= 79)

m.addConstr(33*x0 + 20*x1 + 30*x3 >= 56)
m.addConstr(33*x0 + 20*x1 + 34*x2 >= 56)
m.addConstr(20*x1 + 34*x2 + 30*x3 >= 56)
m.addConstr(33*x0 + 20*x1 + 30*x3 >= 50)
m.addConstr(33*x0 + 20*x1 + 34*x2 >= 50)
m.addConstr(20*x1 + 34*x2 + 30*x3 >= 50)
m.addConstr(33*x0 + 20*x1 + 30*x3 >= 42)
m.addConstr(33*x0 + 20*x1 + 34*x2 >= 42)
m.addConstr(20*x1 + 34*x2 + 30*x3 >= 42)

m.addConstr(27*x0 + 34*x2 >= 20)
m.addConstr(27*x0 + 7*x1 >= 39)
m.addConstr(34*x2 + 4*x3 >= 15)
m.addConstr(7*x1 + 4*x3 >= 42)
m.addConstr(27*x0 + 34*x2 + 4*x3 >= 43)

m.addConstr(16*x0 + 18*x3 <= 179)
m.addConstr(16*x0 + 34*x1 <= 340)
m.addConstr(16*x0 + 9*x2 <= 483)
m.addConstr(34*x1 + 18*x3 <= 479)
m.addConstr(9*x2 + 18*x3 <= 491)
m.addConstr(16*x0 + 34*x1 + 9*x2 <= 241)
m.addConstr(16*x0 + 9*x2 + 18*x3 <= 295)
m.addConstr(16*x0 + 34*x1 + 18*x3 <= 292)
m.addConstr(16*x0 + 34*x1 + 9*x2 + 18*x3 <= 292)

m.addConstr(20*x1 + 34*x2 <= 154)
m.addConstr(34*x2 + 30*x3 <= 265)
m.addConstr(33*x0 + 30*x3 <= 159)
m.addConstr(33*x0 + 34*x2 <= 209)
m.addConstr(33*x0 + 20*x1 + 34*x2 + 30*x3 <= 209)

m.addConstr(7*x1 + 34*x2 <= 88)
m.addConstr(27*x0 + 7*x1 <= 65)
m.addConstr(27*x0 + 34*x2 <= 73)
m.addConstr(34*x2 + 4*x3 <= 95)
m.addConstr(27*x0 + 7*x1 + 34*x2 + 4*x3 <= 95)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Milligrams of vitamin B3: ", x0.varValue)
    print("Milligrams of iron: ", x1.varValue)
    print("Milligrams of vitamin D: ", x2.varValue)
    print("Milligrams of calcium: ", x3.varValue)
    print("Objective function value: ", m.objVal)
else:
    print("No optimal solution found.")
