
from gurobipy import Model, GRB

# Create a new model
model = Model("nutrition_optimization")

# Create variables
potatoes = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potatoes")
lemons = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="lemons")
protein_bars = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="protein_bars")
pickles = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pickles")

# Set objective function
model.setObjective(4 * potatoes + 5 * lemons + 6 * protein_bars + 6 * pickles, GRB.MINIMIZE)

# Add constraints
model.addConstr(12 * potatoes + 11 * lemons + 13 * protein_bars + 12 * pickles <= 95, "c_calcium_upper_bound")
model.addConstr(11 * potatoes + 2 * lemons + 9 * protein_bars + 9 * pickles <= 167, "c_iron_upper_bound")
model.addConstr(13 * potatoes + 2 * lemons + 11 * protein_bars + 6 * pickles <= 103, "c_protein_upper_bound")

model.addConstr(12 * potatoes + 12 * pickles >= 23, "c_calcium_potatoes_pickles")
model.addConstr(12 * potatoes + 13 * protein_bars >= 8, "c_calcium_potatoes_protein_bars")
model.addConstr(12 * potatoes + 13 * protein_bars + 12 * pickles >= 16, "c_calcium_potatoes_protein_bars_pickles")
model.addConstr(11 * lemons + 13 * protein_bars + 12 * pickles >= 16, "c_calcium_lemons_protein_bars_pickles")
model.addConstr(12 * potatoes + 11 * lemons + 12 * pickles >= 16, "c_calcium_potatoes_lemons_pickles")
model.addConstr(12 * potatoes + 11 * lemons + 13 * protein_bars >= 16, "c_calcium_potatoes_lemons_protein_bars")

model.addConstr(12 * potatoes + 13 * protein_bars + 12 * pickles >= 20, "c_calcium_potatoes_protein_bars_pickles_20")
model.addConstr(11 * lemons + 13 * protein_bars + 12 * pickles >= 20, "c_calcium_lemons_protein_bars_pickles_20")
model.addConstr(12 * potatoes + 11 * lemons + 12 * pickles >= 20, "c_calcium_potatoes_lemons_pickles_20")
model.addConstr(12 * potatoes + 11 * lemons + 13 * protein_bars >= 20, "c_calcium_potatoes_lemons_protein_bars_20")

model.addConstr(12 * potatoes + 13 * protein_bars + 12 * pickles >= 19, "c_calcium_potatoes_protein_bars_pickles_19")
model.addConstr(11 * lemons + 13 * protein_bars + 12 * pickles >= 19, "c_calcium_lemons_protein_bars_pickles_19")
model.addConstr(12 * potatoes + 11 * lemons + 12 * pickles >= 19, "c_calcium_potatoes_lemons_pickles_19")
model.addConstr(12 * potatoes + 11 * lemons + 13 * protein_bars >= 19, "c_calcium_potatoes_lemons_protein_bars_19")

model.addConstr(12 * potatoes + 13 * protein_bars + 12 * pickles >= 22, "c_calcium_potatoes_protein_bars_pickles_22")
model.addConstr(11 * lemons + 13 * protein_bars + 12 * pickles >= 22, "c_calcium_lemons_protein_bars_pickles_22")
model.addConstr(12 * potatoes + 11 * lemons + 12 * pickles >= 22, "c_calcium_potatoes_lemons_pickles_22")
model.addConstr(12 * potatoes + 11 * lemons + 13 * protein_bars >= 22, "c_calcium_potatoes_lemons_protein_bars_22")

model.addConstr(12 * potatoes + 11 * lemons + 13 * protein_bars + 12 * pickles >= 22, "c_calcium_all")


model.addConstr(11 * potatoes + 9 * pickles >= 14, "c_iron_potatoes_pickles")
model.addConstr(9 * protein_bars + 9 * pickles >= 32, "c_iron_protein_bars_pickles")
model.addConstr(11 * potatoes + 9 * protein_bars >= 33, "c_iron_potatoes_protein_bars")
model.addConstr(2 * lemons + 9 * pickles >= 17, "c_iron_lemons_pickles")
model.addConstr(11 * potatoes + 2 * lemons + 9 * protein_bars >= 35, "c_iron_potatoes_lemons_protein_bars")
model.addConstr(11 * potatoes + 2 * lemons + 9 * protein_bars + 9 * pickles >= 35, "c_iron_all")

model.addConstr(13 * potatoes + 2 * lemons >= 11, "c_protein_potatoes_lemons")
model.addConstr(13 * potatoes + 11 * protein_bars >= 20, "c_protein_potatoes_protein_bars")
model.addConstr(13 * potatoes + 6 * pickles >= 11, "c_protein_potatoes_pickles")
model.addConstr(13 * potatoes + 2 * lemons + 11 * protein_bars >= 20, "c_protein_potatoes_lemons_protein_bars_20")
model.addConstr(13 * potatoes + 2 * lemons + 6 * pickles >= 20, "c_protein_potatoes_lemons_pickles")
model.addConstr(13 * potatoes + 2 * lemons + 11 * protein_bars >= 18, "c_protein_potatoes_lemons_protein_bars_18")
model.addConstr(13 * potatoes + 2 * lemons + 6 * pickles >= 18, "c_protein_potatoes_lemons_pickles_18")
model.addConstr(13 * potatoes + 2 * lemons + 11 * protein_bars + 6 * pickles >= 18, "c_protein_all")

model.addConstr(7 * lemons - 5 * pickles >= 0, "c_lemons_pickles")
model.addConstr(10 * potatoes - 5 * lemons >= 0, "c_potatoes_lemons")

model.addConstr(12 * potatoes + 11 * lemons + 12 * pickles <= 70, "c_calcium_potatoes_lemons_pickles_upper")
model.addConstr(11 * potatoes + 9 * protein_bars <= 78, "c_iron_potatoes_protein_bars_upper")
model.addConstr(9 * protein_bars + 9 * pickles <= 70, "c_iron_protein_bars_pickles_upper")
model.addConstr(2 * lemons + 9 * protein_bars <= 127, "c_iron_lemons_protein_bars_upper")
model.addConstr(11 * potatoes + 2 * lemons <= 50, "c_iron_potatoes_lemons_upper")
model.addConstr(11 * potatoes + 9 * protein_bars + 9 * pickles <= 151, "c_iron_potatoes_protein_bars_pickles_upper")
model.addConstr(2 * lemons + 9 * protein_bars + 9 * pickles <= 88, "c_iron_lemons_protein_bars_pickles_upper")
model.addConstr(11 * potatoes + 2 * lemons + 9 * pickles <= 90, "c_iron_potatoes_lemons_pickles_upper")

model.addConstr(13 * potatoes + 6 * pickles <= 25, "c_protein_potatoes_pickles_upper")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")
