
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("food_optimization")

# Create variables
foods = ['bagged salads', 'apples', 'hamburgers', 'sashimi', 'bowls of instant ramen']
x = m.addVars(foods, lb=0.0, ub=GRB.INFINITY, name=foods)

# Set objective function
m.setObjective(6*x['bagged salads'] + 4*x['apples'] + 8*x['hamburgers'] + 8*x['sashimi'] + 8*x['bowls of instant ramen'], GRB.MINIMIZE)

# Protein constraints
protein = {'bagged salads': 10, 'apples': 16, 'hamburgers': 25, 'sashimi': 17, 'bowls of instant ramen': 18}
calcium = {'bagged salads': 4, 'apples': 14, 'hamburgers': 12, 'sashimi': 18, 'bowls of instant ramen': 22}

m.addConstr(protein['apples']*x['apples'] + protein['bowls of instant ramen']*x['bowls of instant ramen'] >= 46, "protein_constr1")
m.addConstr(protein['bagged salads']*x['bagged salads'] + protein['bowls of instant ramen']*x['bowls of instant ramen'] >= 77, "protein_constr2")
m.addConstr(protein['bagged salads']*x['bagged salads'] + protein['apples']*x['apples'] >= 76, "protein_constr3")
m.addConstr(protein['bagged salads']*x['bagged salads'] + protein['sashimi']*x['sashimi'] >= 79, "protein_constr4")
m.addConstr(protein['apples']*x['apples'] + protein['hamburgers']*x['hamburgers'] >= 65, "protein_constr5")
m.addConstr(protein['apples']*x['apples'] + protein['sashimi']*x['sashimi'] >= 44, "protein_constr6")
m.addConstr(gp.quicksum(protein[f]*x[f] for f in foods) >= 44, "protein_constr7")

m.addConstr(protein['bagged salads']*x['bagged salads'] + protein['hamburgers']*x['hamburgers'] <= 311, "protein_constr8")
m.addConstr(protein['bagged salads']*x['bagged salads'] + protein['apples']*x['apples'] + protein['bowls of instant ramen']*x['bowls of instant ramen'] <= 371, "protein_constr9")
m.addConstr(protein['apples']*x['apples'] + protein['hamburgers']*x['hamburgers'] + protein['bowls of instant ramen']*x['bowls of instant ramen'] <= 277, "protein_constr10")
m.addConstr(protein['bagged salads']*x['bagged salads'] + protein['apples']*x['apples'] + protein['sashimi']*x['sashimi'] <= 392, "protein_constr11")
m.addConstr(protein['hamburgers']*x['hamburgers'] + protein['sashimi']*x['sashimi'] + protein['bowls of instant ramen']*x['bowls of instant ramen'] <= 196, "protein_constr12")
m.addConstr(protein['bagged salads']*x['bagged salads'] + protein['sashimi']*x['sashimi'] + protein['bowls of instant ramen']*x['bowls of instant ramen'] <= 306, "protein_constr13")
m.addConstr(protein['bagged salads']*x['bagged salads'] + protein['hamburgers']*x['hamburgers'] + protein['bowls of instant ramen']*x['bowls of instant ramen'] <= 245, "protein_constr14")
m.addConstr(protein['apples']*x['apples'] + protein['sashimi']*x['sashimi'] + protein['bowls of instant ramen']*x['bowls of instant ramen'] <= 384, "protein_constr15")
m.addConstr(protein['bagged salads']*x['bagged salads'] + protein['apples']*x['apples'] + protein['hamburgers']*x['hamburgers'] <= 389, "protein_constr16")
m.addConstr(protein['bagged salads']*x['bagged salads'] + protein['hamburgers']*x['hamburgers'] + protein['sashimi']*x['sashimi'] <= 334, "protein_constr17")


# Calcium constraints
m.addConstr(calcium['hamburgers']*x['hamburgers'] + calcium['sashimi']*x['sashimi'] >= 58, "calcium_constr1")
m.addConstr(calcium['apples']*x['apples'] + calcium['bowls of instant ramen']*x['bowls of instant ramen'] >= 88, "calcium_constr2")
m.addConstr(calcium['bagged salads']*x['bagged salads'] + calcium['hamburgers']*x['hamburgers'] >= 39, "calcium_constr3")
m.addConstr(calcium['apples']*x['apples'] + calcium['hamburgers']*x['hamburgers'] >= 80, "calcium_constr4")
m.addConstr(calcium['bagged salads']*x['bagged salads'] + calcium['apples']*x['apples'] >= 91, "calcium_constr5")
m.addConstr(calcium['apples']*x['apples'] + calcium['hamburgers']*x['hamburgers'] + calcium['bowls of instant ramen']*x['bowls of instant ramen'] >= 50, "calcium_constr6")
m.addConstr(calcium['bagged salads']*x['bagged salads'] + calcium['hamburgers']*x['hamburgers'] + calcium['sashimi']*x['sashimi'] >= 50, "calcium_constr7")
m.addConstr(calcium['apples']*x['apples'] + calcium['hamburgers']*x['hamburgers'] + calcium['bowls of instant ramen']*x['bowls of instant ramen'] >= 74, "calcium_constr8")
m.addConstr(calcium['bagged salads']*x['bagged salads'] + calcium['hamburgers']*x['hamburgers'] + calcium['sashimi']*x['sashimi'] >= 74, "calcium_constr9")
m.addConstr(gp.quicksum(calcium[f]*x[f] for f in foods) >= 74, "calcium_constr10")

m.addConstr(calcium['apples']*x['apples'] + calcium['bowls of instant ramen']*x['bowls of instant ramen'] <= 376, "calcium_constr11")
m.addConstr(calcium['bagged salads']*x['bagged salads'] + calcium['apples']*x['apples'] <= 377, "calcium_constr12")
m.addConstr(calcium['hamburgers']*x['hamburgers'] + calcium['bowls of instant ramen']*x['bowls of instant ramen'] <= 398, "calcium_constr13")
m.addConstr(calcium['bagged salads']*x['bagged salads'] + calcium['hamburgers']*x['hamburgers'] <= 130, "calcium_constr14")
m.addConstr(calcium['bagged salads']*x['bagged salads'] + calcium['apples']*x['apples'] + calcium['hamburgers']*x['hamburgers'] <= 136, "calcium_constr15")



# Additional constraints
m.addConstr(3*x['bagged salads'] - 3*x['sashimi'] >= 0, "add_constr1")
m.addConstr(6*x['bagged salads'] - 6*x['hamburgers'] >= 0, "add_constr2")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)
