
from gurobipy import Model, GRB

# Create a new model
model = Model("Resource Allocation")

# Create variables
paper_towels = model.addVar(vtype=GRB.INTEGER, name="paper_towels")
diapers = model.addVar(vtype=GRB.INTEGER, name="diapers")
lightbulbs = model.addVar(vtype=GRB.INTEGER, name="lightbulbs")
dish_soap = model.addVar(vtype=GRB.INTEGER, name="dish_soap")

# Set objective function
model.setObjective(1 * paper_towels + 9 * diapers + 4 * lightbulbs + 6 * dish_soap, GRB.MINIMIZE)

# Add constraints
model.addConstr(14 * diapers + 7 * dish_soap >= 39, "c1")
model.addConstr(9 * paper_towels + 5 * lightbulbs >= 19, "c2")
model.addConstr(9 * paper_towels + 14 * diapers + 5 * lightbulbs + 7 * dish_soap >= 19, "c3")
model.addConstr(13 * paper_towels + 3 * dish_soap >= 55, "c4")
model.addConstr(13 * paper_towels + 8 * lightbulbs >= 44, "c5")
model.addConstr(11 * diapers + 8 * lightbulbs >= 61, "c6")
model.addConstr(11 * diapers + 3 * dish_soap >= 40, "c7")
model.addConstr(11 * diapers + 8 * lightbulbs + 3 * dish_soap >= 51, "c8")
model.addConstr(13 * paper_towels + 11 * diapers + 8 * lightbulbs >= 51, "c9")
model.addConstr(11 * diapers + 8 * lightbulbs + 3 * dish_soap >= 38, "c10")
model.addConstr(13 * paper_towels + 11 * diapers + 8 * lightbulbs >= 38, "c11")
model.addConstr(13 * paper_towels + 11 * diapers + 8 * lightbulbs + 3 * dish_soap >= 38, "c12")
model.addConstr(5 * diapers - 9 * lightbulbs >= 0, "c13")
model.addConstr(9 * paper_towels + 7 * dish_soap <= 161, "c14")
model.addConstr(9 * paper_towels + 5 * lightbulbs <= 155, "c15")
model.addConstr(9 * paper_towels + 14 * diapers + 5 * lightbulbs <= 51, "c16")
model.addConstr(11 * diapers + 8 * lightbulbs <= 255, "c17")
model.addConstr(13 * paper_towels + 11 * diapers <= 223, "c18")
model.addConstr(11 * diapers + 3 * dish_soap <= 250, "c19")
model.addConstr(13 * paper_towels + 8 * lightbulbs <= 277, "c20")
model.addConstr(13 * paper_towels + 3 * dish_soap <= 209, "c21")
model.addConstr(8 * lightbulbs + 3 * dish_soap <= 171, "c22")
model.addConstr(11 * diapers + 8 * lightbulbs + 3 * dish_soap <= 174, "c23")
model.addConstr(13 * paper_towels + 11 * diapers + 8 * lightbulbs <= 76, "c24")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

