
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the decision variables
paper_towel_rolls = m.addVar(vtype=GRB.INTEGER, name="paper_towel_rolls")
diapers = m.addVar(vtype=GRB.INTEGER, name="diapers")
lightbulbs = m.addVar(vtype=GRB.INTEGER, name="lightbulbs")
dish_soap_bottles = m.addVar(vtype=GRB.INTEGER, name="dish_soap_bottles")

# Objective function
m.setObjective(1 * paper_towel_rolls + 9 * diapers + 4 * lightbulbs + 6 * dish_soap_bottles, GRB.MINIMIZE)

# Constraints
# Usefulness rating constraints
m.addConstr(9 * paper_towel_rolls + 14 * diapers + 5 * lightbulbs + 7 * dish_soap_bottles >= 19, name="usefulness_total_min")
m.addConstr(14 * diapers + 7 * dish_soap_bottles >= 39, name="diapers_dish_soap_usefulness_min")
m.addConstr(9 * paper_towel_rolls + 5 * lightbulbs >= 19, name="paper_lightbulb_usefulness_min")
m.addConstr(paper_towel_rolls * 9 + dish_soap_bottles * 7 <= 161, name="paper_dish_max")

# Sustainability score constraints
m.addConstr(13 * paper_towel_rolls + 3 * dish_soap_bottles >= 55, name="paper_dish_sustainability_min")
m.addConstr(13 * paper_towel_rolls + 8 * lightbulbs >= 44, name="paper_lightbulb_sustainability_min")
m.addConstr(11 * diapers + 8 * lightbulbs >= 61, name="diapers_lightbulb_sustainability_min")
m.addConstr(11 * diapers + 3 * dish_soap_bottles >= 40, name="diapers_dish_sustainability_min")
m.addConstr(11 * diapers + 8 * lightbulbs + 3 * dish_soap_bottles >= 51, name="diapers_lightbulb_dish_sustainability_min")
m.addConstr(13 * paper_towel_rolls + 11 * diapers + 8 * lightbulbs >= 51, name="paper_diaper_lightbulb_sustainability_min")
m.addConstr(13 * paper_towel_rolls + 11 * diapers + 8 * lightbulbs + 3 * dish_soap_bottles >= 38, name="all_items_sustainability_min")

# Additional constraints
m.addConstr(5 * diapers - 9 * lightbulbs >= 0, name="diaper_lightbulb_relation")
m.addConstr(paper_towel_rolls * 13 + diapers * 11 <= 223, name="paper_diapers_max_sustainability")
m.addConstr(diapers * 11 + lightbulbs * 8 <= 255, name="diaper_lightbulb_max_sustainability")

# Solve the model
m.optimize()

