
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    apple_pies = m.addVar(vtype=GRB.CONTINUOUS, name="apple_pies")
    cantaloupes = m.addVar(vtype=GRB.INTEGER, name="cantaloupes")

    # Set objective function
    m.setObjective(1.42 * apple_pies + 8.78 * cantaloupes, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3.47 * apple_pies + 0.49 * cantaloupes >= 19, "calcium_min")
    m.addConstr(4.7 * apple_pies + 3.14 * cantaloupes >= 23, "iron_min")
    m.addConstr(5.64 * apple_pies + 1.53 * cantaloupes >= 7, "protein_min")
    m.addConstr(3 * apple_pies - 9 * cantaloupes >= 0, "combined_constraint")

    m.addConstr(3.47 * apple_pies + 0.49 * cantaloupes <= 30, "calcium_max1")
    m.addConstr(3.47 * apple_pies + 0.49 * cantaloupes <= 30, "calcium_max2") # Redundant
    m.addConstr(4.7 * apple_pies + 3.14 * cantaloupes <= 28, "iron_max1")
    m.addConstr(4.7 * apple_pies + 3.14 * cantaloupes <= 28, "iron_max2") # Redundant
    m.addConstr(5.64 * apple_pies + 1.53 * cantaloupes <= 26, "protein_max1")
    m.addConstr(5.64 * apple_pies + 1.53 * cantaloupes <= 26, "protein_max2") # Redundant


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('apple_pies: %g' % apple_pies.x)
        print('cantaloupes: %g' % cantaloupes.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
