
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apple_pies")
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="cantaloupes")

# Objective function: Maximize 1.42*x0 + 8.78*x1
m.setObjective(1.42 * x0 + 8.78 * x1, GRB.MAXIMIZE)

# Constraints
m.addConstr(3.47*x0 + 0.49*x1 >= 19, "calcium_lower_bound")
m.addConstr(3.47*x0 + 0.49*x1 <= 30, "calcium_upper_bound")

m.addConstr(4.7*x0 + 3.14*x1 >= 23, "iron_lower_bound")
m.addConstr(4.7*x0 + 3.14*x1 <= 28, "iron_upper_bound")

m.addConstr(5.64*x0 + 1.53*x1 >= 7, "protein_lower_bound")
m.addConstr(5.64*x0 + 1.53*x1 <= 26, "protein_upper_bound")

m.addConstr(3*x0 - 9*x1 >= 0, "pies_cantaloupes_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Apple Pies: {x0.x}")
    print(f"Cantaloupes: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
