
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    apple_pies = model.addVar(name="apple_pies", lb=0, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.CONTINUOUS)
    cantaloupes = model.addVar(name="cantaloupes", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(1.42 * apple_pies + 8.78 * cantaloupes, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Calcium constraints
    model.addConstr(3.47 * apple_pies + 0.49 * cantaloupes >= 19, name="calcium_min")
    model.addConstr(3.47 * apple_pies + 0.49 * cantaloupes <= 30, name="calcium_max")

    # Iron constraints
    model.addConstr(4.7 * apple_pies + 3.14 * cantaloupes >= 23, name="iron_min")
    model.addConstr(4.7 * apple_pies + 3.14 * cantaloupes <= 28, name="iron_max")

    # Protein constraints
    model.addConstr(5.64 * apple_pies + 1.53 * cantaloupes >= 7, name="protein_min")
    model.addConstr(5.64 * apple_pies + 1.53 * cantaloupes <= 26, name="protein_max")

    # Additional constraint
    model.addConstr(3 * apple_pies - 9 * cantaloupes >= 0, name="additional_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Apple pies: {apple_pies.varValue}")
        print(f"Cantaloupes: {cantaloupes.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
