
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize Labor Cost")

# Create variables
john_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="john_hours")
bobby_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="bobby_hours")
peggy_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="peggy_hours")
bill_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="bill_hours")

# Set objective function
model.setObjective(5.01 * john_hours + 5.97 * bobby_hours + 8.09 * peggy_hours + 5.78 * bill_hours, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(7 * bobby_hours + 5 * peggy_hours >= 5, "c1")
model.addConstr(5 * peggy_hours + 1 * bill_hours >= 7, "c2")
model.addConstr(5 * john_hours + 5 * peggy_hours >= 10, "c3")
model.addConstr(5 * john_hours + 7 * bobby_hours + 5 * peggy_hours + 1 * bill_hours >= 10, "c4")
model.addConstr(john_hours - bobby_hours >= 0, "c5")
model.addConstr(9 * peggy_hours - 10 * bill_hours >= 0, "c6")
model.addConstr(5 * peggy_hours + 1 * bill_hours <= 41, "c7")
model.addConstr(7 * bobby_hours + 5 * peggy_hours <= 29, "c8")
model.addConstr(5 * john_hours + 7 * bobby_hours + 5 * peggy_hours <= 28, "c9")
model.addConstr(5 * john_hours + 7 * bobby_hours + 1 * bill_hours <= 16, "c10")
model.addConstr(7 * bobby_hours + 5 * peggy_hours + 1 * bill_hours <= 30, "c11")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('John Hours: %g' % john_hours.x)
    print('Bobby Hours: %g' % bobby_hours.x)
    print('Peggy Hours: %g' % peggy_hours.x)
    print('Bill Hours: %g' % bill_hours.x)
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

