
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
J = m.addVar(name="hours_worked_by_John", lb=0)  # No upper bound given, assuming continuous
B = m.addVar(name="hours_worked_by_Bobby", lb=0)  # No upper bound given, assuming continuous
P = m.addVar(name="hours_worked_by_Peggy", lb=0)  # No upper bound given, assuming continuous
H = m.addVar(name="hours_worked_by_Bill", lb=0)  # No upper bound given, assuming continuous

# Define the objective function
m.setObjective(5.01*J + 5.97*B + 8.09*P + 5.78*H, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5*J + 7*B + 5*P + H <= 41, name="total_productivity_upper_bound")
m.addConstr(7*B + 5*P >= 5, name="Bobby_Peggy_combined_productivity")
m.addConstr(5*P + H >= 7, name="Peggy_Bill_combined_productivity")
m.addConstr(5*J + 5*P >= 10, name="John_Peggy_combined_productivity")
m.addConstr(5*J + 7*B + 5*P + H >= 10, name="total_combined_productivity")
m.addConstr(J - B >= 0, name="John_Bobby_hours_worked")
m.addConstr(9*P - 10*H >= 0, name="Peggy_Bill_hours_worked")
m.addConstr(5*P + H <= 41, name="Peggy_Bill_productivity_upper_bound")
m.addConstr(7*B + 5*P <= 29, name="Bobby_Peggy_productivity_upper_bound")
m.addConstr(5*J + 7*B + 5*P <= 28, name="John_Bobby_Peggy_productivity_upper_bound")
m.addConstr(5*J + 7*B + H <= 16, name="John_Bobby_Bill_productivity_upper_bound")
m.addConstr(7*B + 5*P + H <= 30, name="Bobby_Peggy_Bill_productivity_upper_bound")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by John: {J.varValue}")
    print(f"Hours worked by Bobby: {B.varValue}")
    print(f"Hours worked by Peggy: {P.varValue}")
    print(f"Hours worked by Bill: {H.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
