
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
ravioli = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ravioli")
cornichons = model.addVar(lb=0, vtype=GRB.INTEGER, name="cornichons")

# Set objective function
model.setObjective(1.89 * ravioli + 6.47 * cornichons, GRB.MINIMIZE)

# Add constraints
model.addConstr(7 * ravioli + 3 * cornichons >= 8, "healthiness_min")
model.addConstr(7 * ravioli + 3 * cornichons <= 24, "healthiness_max")
model.addConstr(1 * ravioli + 7 * cornichons >= 13, "calcium_min")
model.addConstr(1 * ravioli + 7 * cornichons <= 32, "calcium_max")
model.addConstr(7 * ravioli + 4 * cornichons >= 23, "carbs_min")
model.addConstr(7 * ravioli + 4 * cornichons <= 46, "carbs_max")
model.addConstr(1 * ravioli - 2 * cornichons >= 0, "ravioli_cornichons_ratio")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Ravioli: {ravioli.x}")
    print(f"  Cornichons: {cornichons.x}")
    print(f"  Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

