
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(name='ravioli', lb=0)  # Amount of ravioli (non-integer)
x1 = m.addVar(vtype=GRB.INTEGER, name='cornichons', lb=0)  # Number of cornichons (integer)

# Objective function
m.setObjective(1.89*x0 + 6.47*x1, GRB.MINIMIZE)

# Constraints
# Healthiness rating constraints
m.addConstr(x0*7 + x1*3 >= 8, name='min_healthiness')
m.addConstr(x0*7 + x1*3 <= 24, name='max_healthiness')

# Calcium content constraint
m.addConstr(x0*1 + x1*7 >= 13, name='min_calcium')
m.addConstr(x0*1 + x1*7 <= 32, name='max_calcium')

# Carbohydrate content constraint
m.addConstr(x0*7 + x1*4 >= 23, name='min_carbs')
m.addConstr(x0*7 + x1*4 <= 46, name='max_carbs')

# Additional constraint: 1*x0 - 2*x1 >= 0
m.addConstr(x0 - 2*x1 >= 0, name='additional_constraint')

# Solve the model
m.optimize()

print("Objective Function Value:", m.ObjVal)
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
