
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
ravioli = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="ravioli")
cornichons = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, type=gurobi.GRB.INTEGER, name="cornichons")

# Objective function: Minimize 1.89 * ravioli + 6.47 * cornichons
model.setObjective(1.89 * ravioli + 6.47 * cornichons, gurobi.GRB.MINIMIZE)

# Constraints
# Healthiness rating constraints
model.addConstraint(7 * ravioli + 3 * cornichons >= 8, name="healthiness_rating_min")
model.addConstraint(7 * ravioli + 3 * cornichons <= 24, name="healthiness_rating_max")

# Calcium constraints
model.addConstraint(1 * ravioli + 7 * cornichons >= 13, name="calcium_min")
model.addConstraint(1 * ravioli + 7 * cornichons <= 32, name="calcium_max")

# Carbohydrates constraints
model.addConstraint(7 * ravioli + 4 * cornichons >= 23, name="carbohydrates_min")
model.addConstraint(7 * ravioli + 4 * cornichons <= 46, name="carbohydrates_max")

# Additional constraint
model.addConstraint(ravioli - 2 * cornichons >= 0, name="additional_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Ravioli: {ravioli.varValue}")
    print(f"Cornichons: {cornichons.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
