
from gurobipy import Model, GRB

# Create a new model
model = Model("Employee_Hours")

# Create variables
john = model.addVar(vtype=GRB.CONTINUOUS, name="John")
paul = model.addVar(vtype=GRB.INTEGER, name="Paul")
hank = model.addVar(vtype=GRB.CONTINUOUS, name="Hank")
bill = model.addVar(vtype=GRB.INTEGER, name="Bill")
dale = model.addVar(vtype=GRB.INTEGER, name="Dale")
ringo = model.addVar(vtype=GRB.INTEGER, name="Ringo")
bobby = model.addVar(vtype=GRB.INTEGER, name="Bobby")

# Set objective function
model.setObjective(5*john + 2*paul + 3*hank + 5*bill + 7*dale + 8*ringo + 2*bobby, GRB.MAXIMIZE)

# Likelihood to quit index (r0)
r0 = {'John': 9, 'Paul': 7, 'Hank': 7, 'Bill': 14, 'Dale': 14, 'Ringo': 8, 'Bobby': 4}

# Organization score (r1)
r1 = {'John': 7, 'Paul': 18, 'Hank': 3, 'Bill': 15, 'Dale': 1, 'Ringo': 10, 'Bobby': 12}

# Add constraints
model.addConstr(14*bill + 14*dale >= 56)
model.addConstr(7*paul + 14*bill + 14*dale >= 73)
model.addConstr(7*paul + 14*bill + 4*bobby >= 73)
model.addConstr(9*john + 7*hank + 14*dale >= 73)
model.addConstr(7*paul + 14*bill + 14*dale >= 59)
model.addConstr(7*paul + 14*bill + 4*bobby >= 59)
model.addConstr(9*john + 7*hank + 14*dale >= 59)
model.addConstr(7*paul + 14*bill + 14*dale >= 63)
model.addConstr(7*paul + 14*bill + 4*bobby >= 63)
model.addConstr(9*john + 7*hank + 14*dale >= 63)

model.addConstr(7*john + 1*dale >= 42)
model.addConstr(3*hank + 12*bobby >= 45)
model.addConstr(15*bill + 12*bobby >= 37)
model.addConstr(3*hank + 15*bill >= 24)
model.addConstr(5*john - bobby >= 0)


# Likelihood to quit index upper bounds
model.addConstr(9*john + 7*hank <= 359)
model.addConstr(14*dale + 8*ringo <= 183)
model.addConstr(14*bill + 8*ringo <= 147)
model.addConstr(14*bill + 14*dale <= 445)
model.addConstr(9*john + 4*bobby <= 495)
model.addConstr(7*hank + 14*bill <= 275)
model.addConstr(7*paul + 14*bill <= 438)
model.addConstr(7*paul + 14*dale <= 361)
model.addConstr(9*john + 14*dale <= 309)
model.addConstr(14*bill + 4*bobby <= 521)
model.addConstr(14*dale + 4*bobby <= 141)
model.addConstr(9*john + 14*bill <= 472)
model.addConstr(7*paul + 7*hank <= 141)
model.addConstr(7*hank + 14*dale <= 529)
model.addConstr(7*hank + 4*bobby <= 119)
model.addConstr(9*john + 8*ringo <= 183)
model.addConstr(9*john + 7*paul <= 183)
model.addConstr(8*ringo + 4*bobby <= 129)

model.addConstr(7*hank + 14*bill + 4*bobby <= 151)
model.addConstr(9*john + 14*dale + 4*bobby <= 170)
model.addConstr(9*john + 7*hank + 14*bill <= 470)
model.addConstr(7*paul + 14*bill + 8*ringo <= 348)
model.addConstr(7*paul + 7*hank + 8*ringo <= 456)
model.addConstr(9*john + 7*paul + 8*ringo <= 346)
model.addConstr(7*paul + 7*hank + 4*bobby <= 543)
model.addConstr(14*bill + 14*dale + 4*bobby <= 545)
model.addConstr(7*paul + 14*dale + 8*ringo <= 142)
model.addConstr(7*hank + 14*dale + 8*ringo <= 592)
model.addConstr(7*paul + 14*bill + 14*dale <= 215)
model.addConstr(7*paul + 7*hank + 14*dale <= 196)
model.addConstr(9*john + 7*paul + 7*hank + 14*bill + 14*dale + 8*ringo + 4*bobby <= 196)


# Organization score upper bounds
model.addConstr(3*hank + 12*bobby <= 109)
model.addConstr(18*paul + 3*hank <= 101)
model.addConstr(7*john + 10*ringo <= 207)
model.addConstr(18*paul + 15*bill <= 172)
model.addConstr(10*ringo + 12*bobby <= 109)
model.addConstr(7*john + 18*paul + 1*dale <= 261)
model.addConstr(18*paul + 3*hank + 12*bobby <= 226)
model.addConstr(7*john + 15*bill + 10*ringo <= 202)
model.addConstr(7*john + 18*paul + 15*bill <= 135)
model.addConstr(15*bill + 1*dale + 10*ringo <= 156)
model.addConstr(3*hank + 1*dale + 10*ringo <= 161)
model.addConstr(7*john + 18*paul + 12*bobby <= 230)
model.addConstr(7*john + 3*hank + 1*dale <= 241)
model.addConstr(18*paul + 15*bill + 1*dale <= 289)
model.addConstr(18*paul + 3*hank + 1*dale <= 72)
model.addConstr(18*paul + 3*hank + 10*ringo <= 156)
model.addConstr(7*john + 18*paul + 3*hank + 15*bill + 1*dale + 10*ringo + 12*bobby <= 156)


# Resource upper bounds (given in the problem description)
model.addConstr(9*john + 7*paul + 7*hank + 14*bill + 14*dale + 8*ringo + 4*bobby <= 648) # r0
model.addConstr(7*john + 18*paul + 3*hank + 15*bill + 1*dale + 10*ringo + 12*bobby <= 323) # r1


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

