
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_b4 = m.addVar(name="vitamin_b4", lb=0.0)
    potassium = m.addVar(name="potassium", lb=0.0)
    vitamin_b1 = m.addVar(name="vitamin_b1", lb=0.0)
    vitamin_b6 = m.addVar(name="vitamin_b6", lb=0.0)

    # Set objective function
    m.setObjective(2 * vitamin_b4 + 5 * potassium + 8 * vitamin_b1 + 9 * vitamin_b6, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(6.49 * vitamin_b4 + 7.23 * vitamin_b6 >= 49, "immune_b4_b6")
    m.addConstr(2.09 * vitamin_b4 + 9.55 * vitamin_b6 >= 34, "cardio_b4_b6")
    m.addConstr(15.8 * potassium + 13.81 * vitamin_b1 <= 259, "immune_k_b1")
    m.addConstr(15.8 * potassium + 13.81 * vitamin_b1 + 7.23 * vitamin_b6 <= 142, "immune_k_b1_b6")
    m.addConstr(6.49 * vitamin_b4 + 15.8 * potassium + 13.81 * vitamin_b1 <= 156, "immune_b4_k_b1")
    m.addConstr(6.49 * vitamin_b4 + 15.8 * potassium + 7.23 * vitamin_b6 <= 148, "immune_b4_k_b6")
    m.addConstr(6.49 * vitamin_b4 + 15.8 * potassium + 13.81 * vitamin_b1 + 7.23 * vitamin_b6 <= 148, "immune_all")
    m.addConstr(4.16 * vitamin_b1 + 9.55 * vitamin_b6 <= 295, "cardio_b1_b6")
    m.addConstr(0.7 * potassium + 4.16 * vitamin_b1 <= 178, "cardio_k_b1")
    m.addConstr(0.7 * potassium + 4.16 * vitamin_b1 + 9.55 * vitamin_b6 <= 113, "cardio_k_b1_b6")
    m.addConstr(2.09 * vitamin_b4 + 0.7 * potassium + 4.16 * vitamin_b1 <= 96, "cardio_b4_k_b1")
    m.addConstr(2.09 * vitamin_b4 + 0.7 * potassium + 4.16 * vitamin_b1 + 9.55 * vitamin_b6 <= 96, "cardio_all")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
