
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x0 = m.addVar(name="milligrams_of_vitamin_B4", lb=0)
x1 = m.addVar(name="milligrams_of_potassium", lb=0)
x2 = m.addVar(name="milligrams_of_vitamin_B1", lb=0)
x3 = m.addVar(name="milligrams_of_vitamin_B6", lb=0)

# Objective function
m.setObjective(2*x0 + 5*x1 + 8*x2 + 9*x3, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(6.49*x0 + 7.23*x3 >= 49)
m.addConstr(2.09*x0 + 9.55*x3 >= 34)
m.addConstr(15.8*x1 + 13.81*x2 <= 259)
m.addConstr(15.8*x1 + 13.81*x2 + 7.23*x3 <= 142)
m.addConstr(6.49*x0 + 15.8*x1 + 13.81*x2 <= 156)
m.addConstr(6.49*x0 + 15.8*x1 + 13.81*x2 + 7.23*x3 <= 148)
m.addConstr(4.16*x2 + 9.55*x3 <= 295)
m.addConstr(0.7*x1 + 4.16*x2 <= 178)
m.addConstr(0.7*x1 + 4.16*x2 + 9.55*x3 <= 113)
m.addConstr(2.09*x0 + 0.7*x1 + 4.16*x2 <= 96)
m.addConstr(2.09*x0 + 0.7*x1 + 4.16*x2 + 9.55*x3 <= 96)

# Optimize
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Milligrams of vitamin B4: ", x0.varValue)
    print("Milligrams of potassium: ", x1.varValue)
    print("Milligrams of vitamin B1: ", x2.varValue)
    print("Milligrams of vitamin B6: ", x3.varValue)
else:
    print("The problem is infeasible")
