
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_k = m.addVar(lb=0, name="vitamin_k")  # Non-negative
    vitamin_d = m.addVar(lb=0, name="vitamin_d")  # Non-negative

    # Set objective function
    m.setObjective(3 * vitamin_k + 6 * vitamin_d, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(7 * vitamin_k + 11 * vitamin_d >= 17, "kidney_support_min")
    m.addConstr(1 * vitamin_k + 9 * vitamin_d >= 27, "energy_stability_min")
    m.addConstr(5 * vitamin_k + 5 * vitamin_d >= 22, "immune_support_min")
    m.addConstr(-10 * vitamin_k + 3 * vitamin_d >= 0, "vitamin_ratio")
    m.addConstr(7 * vitamin_k + 11 * vitamin_d <= 54, "kidney_support_max") # Combined kidney support max constraint
    m.addConstr(1 * vitamin_k + 9 * vitamin_d <= 83, "energy_stability_max") # Combined energy stability max constraint
    m.addConstr(5 * vitamin_k + 5 * vitamin_d <= 28, "immune_support_max") # Combined immune support max constraint


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal objective value: {m.objVal}")
        print(f"Milligrams of Vitamin K: {vitamin_k.x}")
        print(f"Milligrams of Vitamin D: {vitamin_d.x}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
