
import gurobi

def optimize_vitamins():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    vitamin_K = model.addVar(lb=0, name="vitamin_K")  # Milligrams of vitamin K
    vitamin_D = model.addVar(lb=0, name="vitamin_D")  # Milligrams of vitamin D

    # Objective function: Maximize 3 * vitamin_K + 6 * vitamin_D
    model.setObjective(3 * vitamin_K + 6 * vitamin_D, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(7 * vitamin_K + 11 * vitamin_D >= 17, name="kidney_support_min")
    model.addConstr(vitamin_K + 9 * vitamin_D >= 27, name="energy_stability_min")
    model.addConstr(5 * vitamin_K + 5 * vitamin_D >= 22, name="immune_support_min")
    model.addConstr(-10 * vitamin_K + 3 * vitamin_D >= 0, name="linear_constraint")
    model.addConstr(7 * vitamin_K + 11 * vitamin_D <= 54, name="kidney_support_max")
    model.addConstr(vitamin_K + 9 * vitamin_D <= 83, name="energy_stability_max")
    model.addConstr(5 * vitamin_K + 5 * vitamin_D <= 28, name="immune_support_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin K: {vitamin_K.varValue}")
        print(f"Milligrams of vitamin D: {vitamin_D.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
