
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
lanyards = model.addVar(vtype=GRB.INTEGER, name="lanyards")
color_printers = model.addVar(vtype=GRB.INTEGER, name="color_printers")

# Set objective function
model.setObjective(3 * lanyards + 3 * color_printers, GRB.MINIMIZE)

# Add constraints
model.addConstr(4 * lanyards + 23 * color_printers >= 61, "c1_usefulness_min")
model.addConstr(23 * lanyards + 9 * color_printers >= 48, "c2_storage_min")
model.addConstr(6 * lanyards - 6 * color_printers >= 0, "c3_lanyards_printers_ratio")
model.addConstr(4 * lanyards + 23 * color_printers <= 79, "c4_usefulness_max")
model.addConstr(23 * lanyards + 9 * color_printers <= 81, "c5_storage_max")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print('Optimal objective value:', model.objVal)
    print('lanyards:', lanyards.x)
    print('color_printers:', color_printers.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print(f"Optimization terminated with status {model.status}")

