
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
lanyards = m.addVar(vtype=GRB.INTEGER, name="lanyards")
color_printers = m.addVar(vtype=GRB.INTEGER, name="color_printers")

# Objective function: minimize 3*lanyards + 3*color_printers
m.setObjective(3 * lanyards + 3 * color_printers, GRB.MINIMIZE)

# Constraints
m.addConstr(4 * lanyards + 23 * color_printers >= 61, name="usefulness_rating_min")
m.addConstr(23 * lanyards + 9 * color_printers >= 48, name="storage_space_min")
m.addConstr(6 * lanyards - 6 * color_printers >= 0, name="linear_combination")
m.addConstr(4 * lanyards + 23 * color_printers <= 79, name="usefulness_rating_max")
m.addConstr(23 * lanyards + 9 * color_printers <= 81, name="storage_space_max")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: lanyards={lanyards.x}, color_printers={color_printers.x}")
else:
    print("No optimal solution found")
