
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
lanyards = model.addVar(name="lanyards", vtype=gurobi.GRB.INTEGER)
color_printers = model.addVar(name="color_printers", vtype=gurobi.GRB.INTEGER)

# Objective function: minimize 3 * lanyards + 3 * color_printers
model.setObjective(3 * lanyards + 3 * color_printers, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(4 * lanyards + 23 * color_printers >= 61)  # usefulness rating >= 61
model.addConstr(23 * lanyards + 9 * color_printers >= 48)  # storage space >= 48
model.addConstr(6 * lanyards - 6 * color_printers >= 0)  # 6 * lanyards - 6 * color_printers >= 0
model.addConstr(4 * lanyards + 23 * color_printers <= 79)  # usefulness rating <= 79
model.addConstr(23 * lanyards + 9 * color_printers <= 81)  # storage space <= 81

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Lanyards: {lanyards.varValue}")
    print(f"Color Printers: {color_printers.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
