
import gurobipy as gp

# Create a new model
m = gp.Model("Military_Optimization")

# Define variables
teams = ['pathfinder teams', 'reconnaissance troops', 'logistics companies', 'air defense batteries', 'water purification units', 'CBRN platoons', 'military intelligence companies']
x = m.addVars(teams, vtype=gp.GRB.INTEGER, name=teams)

# Define objective function
obj = 6.78 * x['pathfinder teams'] + 6.59 * x['reconnaissance troops'] + 8.41 * x['logistics companies'] + 3.07 * x['air defense batteries'] + 1.46 * x['water purification units'] + 7.72 * x['CBRN platoons'] + 9.57 * x['military intelligence companies']
m.setObjective(obj, gp.GRB.MAXIMIZE)

# Define defensive capability ratings
ratings = {'pathfinder teams': 3.22, 'reconnaissance troops': 8.24, 'logistics companies': 8.63, 'air defense batteries': 0.36, 'water purification units': 6.01, 'CBRN platoons': 8.75, 'military intelligence companies': 1.02}

# Add constraints
m.addConstr(x['pathfinder teams'] * ratings['pathfinder teams'] + x['logistics companies'] * ratings['logistics companies'] >= 13)
m.addConstr(x['pathfinder teams'] * ratings['pathfinder teams'] + x['military intelligence companies'] * ratings['military intelligence companies'] >= 17)
m.addConstr(x['pathfinder teams'] * ratings['pathfinder teams'] + x['reconnaissance troops'] * ratings['reconnaissance troops'] + x['air defense batteries'] * ratings['air defense batteries'] >= 17)
m.addConstr(x['reconnaissance troops'] * ratings['reconnaissance troops'] + x['water purification units'] * ratings['water purification units'] + x['CBRN platoons'] * ratings['CBRN platoons'] >= 17)
# ... (Add all other similar constraints using the provided data) ...

# Total defensive capability upper bound
m.addConstr(gp.quicksum(x[team] * ratings[team] for team in teams) <= 226)

# Global upper bound constraint
m.addConstr(gp.quicksum(x[team] for team in teams) <= 73)


# Optimize the model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    for team in teams:
        print(f"{team}: {x[team].x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

