
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
george_hours = m.addVar(vtype=GRB.INTEGER, name="george_hours")
bill_hours = m.addVar(vtype=GRB.CONTINUOUS, name="bill_hours")
john_hours = m.addVar(vtype=GRB.CONTINUOUS, name="john_hours")

# Set objective function
m.setObjective(7.68 * george_hours**2 + 8.67 * george_hours * bill_hours + 3.79 * bill_hours**2 + 6.11 * bill_hours * john_hours + 6.09 * john_hours**2 + 4.46 * george_hours + 3.47 * bill_hours + 3.11 * john_hours, GRB.MINIMIZE)

# Add constraints
m.addConstr(3.2 * bill_hours + 5.58 * john_hours >= 26, "c1")
m.addConstr(1.95 * george_hours + 3.2 * bill_hours + 5.58 * john_hours >= 26, "c2")
m.addConstr(15.65 * george_hours**2 + 10.13 * john_hours**2 >= 33, "c3")
m.addConstr(15.65 * george_hours + 1.68 * bill_hours >= 34, "c4")
m.addConstr(15.65 * george_hours + 1.68 * bill_hours + 10.13 * john_hours >= 34, "c5")
m.addConstr(14.78 * george_hours + 0.75 * bill_hours >= 33, "c6")
m.addConstr(0.75 * bill_hours + 5.11 * john_hours >= 32, "c7")
m.addConstr(14.78 * george_hours + 0.75 * bill_hours + 5.11 * john_hours >= 32, "c8")
m.addConstr(8.5 * george_hours + 14.06 * john_hours >= 25, "c9")
m.addConstr(10.83 * bill_hours + 14.06 * john_hours >= 29, "c10")
m.addConstr(8.5 * george_hours + 10.83 * bill_hours + 14.06 * john_hours >= 29, "c11")
m.addConstr(10 * bill_hours - 7 * john_hours >= 0, "c12")
m.addConstr(9 * george_hours - 9 * bill_hours >= 0, "c13")
m.addConstr(1.95 * george_hours + 3.2 * bill_hours <= 36, "c14")
m.addConstr(1.68 * bill_hours + 10.13 * john_hours <= 119, "c15")
m.addConstr(8.5 * george_hours**2 + 10.83 * bill_hours**2 <= 71, "c16")
m.addConstr(8.5 * george_hours + 10.83 * bill_hours + 14.06 * john_hours <= 162, "c17")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('George Hours:', george_hours.x)
    print('Bill Hours:', bill_hours.x)
    print('John Hours:', john_hours.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
