
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
G = m.addVar(lb=0, name="hours_worked_by_George", vtype=gp.GRB.INTEGER)
B = m.addVar(lb=0, name="hours_worked_by_Bill")
J = m.addVar(lb=0, name="hours_worked_by_John")

# Objective function
m.setObjective(7.68*G**2 + 8.67*G*B + 3.79*B**2 + 6.11*B*J + 6.09*J**2 + 4.46*G + 3.47*B + 3.11*J, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(1.95*G <= 107)
m.addConstr(15.65*G <= 166)
m.addConstr(14.78*G <= 146)
m.addConstr(8.5*G <= 163)
m.addConstr(3.2*B <= 107)
m.addConstr(1.68*B <= 166)
m.addConstr(0.75*B <= 146)
m.addConstr(10.83*B <= 163)
m.addConstr(5.58*J <= 107)
m.addConstr(10.13*J <= 166)
m.addConstr(5.11*J <= 146)
m.addConstr(14.06*J <= 163)
m.addConstr(3.2*B + 5.58*J >= 26)
m.addConstr(1.95*G + 3.2*B + 5.58*J >= 26)
m.addConstr(15.65*G**2 + 10.13*J**2 >= 33)
m.addConstr(15.65*G + 1.68*B >= 34)
m.addConstr(15.65*G + 1.68*B + 10.13*J >= 34)
m.addConstr(14.78*G + 0.75*B >= 33)
m.addConstr(0.75*B + 5.11*J >= 32)
m.addConstr(14.78*G + 0.75*B + 5.11*J >= 32)
m.addConstr(8.5*G + 14.06*J >= 25)
m.addConstr(10.83*B + 14.06*J >= 29)
m.addConstr(8.5*G + 10.83*B + 14.06*J >= 29)
m.addConstr(10*B - 7*J >= 0)
m.addConstr(9*G - 9*B >= 0)
m.addConstr(1.95*G + 3.2*B <= 36)
m.addConstr(1.68*B + 10.13*J <= 119)
m.addConstr(8.5*G**2 + 10.83*B**2 <= 71)
m.addConstr(8.5*G + 10.83*B + 14.06*J <= 162)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by George: ", G.varValue)
    print("Hours worked by Bill: ", B.varValue)
    print("Hours worked by John: ", J.varValue)
else:
    print("The model is infeasible")
