
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
lightbulbs = m.addVar(vtype=GRB.INTEGER, name="lightbulbs")
rubber_gloves = m.addVar(vtype=GRB.INTEGER, name="rubber_gloves")
paper_towel_rolls = m.addVar(vtype=GRB.INTEGER, name="paper_towel_rolls")

# Set objective function
m.setObjective(3 * lightbulbs + 8 * rubber_gloves + 9 * paper_towel_rolls, GRB.MAXIMIZE)

# Add constraints
m.addConstr(-5 * lightbulbs + 4 * paper_towel_rolls >= 0, "c1")
m.addConstr(6.34 * rubber_gloves + 7.49 * paper_towel_rolls <= 27, "c2")
m.addConstr(4.47 * lightbulbs + 6.34 * rubber_gloves <= 37, "c3")
m.addConstr(4.47 * lightbulbs + 6.34 * rubber_gloves + 7.49 * paper_towel_rolls <= 51, "c4")
m.addConstr(0.66 * lightbulbs + 6.28 * paper_towel_rolls <= 80, "c5")
m.addConstr(0.66 * lightbulbs + 3.04 * rubber_gloves <= 48, "c6")
m.addConstr(0.66 * lightbulbs + 3.04 * rubber_gloves + 6.28 * paper_towel_rolls <= 74, "c7")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('lightbulbs:', lightbulbs.x)
    print('rubber_gloves:', rubber_gloves.x)
    print('paper_towel_rolls:', paper_towel_rolls.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
