
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
lightbulbs = model.addVar(name="lightbulbs", vtype=gurobi.GRB.INTEGER)
rubber_gloves = model.addVar(name="rubber_gloves", vtype=gurobi.GRB.INTEGER)
paper_towel_rolls = model.addVar(name="paper_towel_rolls", vtype=gurobi.GRB.INTEGER)

# Objective function coefficients
obj_func_coefs = [3, 8, 9]

# Define the objective function
model.setObjective(obj_func_coefs[0]*lightbulbs + obj_func_coefs[1]*rubber_gloves + obj_func_coefs[2]*paper_towel_rolls, gurobi.GRB.MAXIMIZE)

# Attribute values
r0 = {'lightbulbs': 4.47, 'rubber_gloves': 6.34, 'paper_towel_rolls': 7.49}
r1 = {'lightbulbs': 0.66, 'rubber_gloves': 3.04, 'paper_towel_rolls': 6.28}

# Constraints
# 7. -5 * lightbulbs + 4 * paper_towel_rolls >= 0
model.addConstr(-5 * lightbulbs + 4 * paper_towel_rolls >= 0, name="constraint_7")

# 8. rubber_gloves usefulness rating + paper_towel_rolls usefulness rating <= 27
model.addConstr(r0['rubber_gloves']*rubber_gloves + r0['paper_towel_rolls']*paper_towel_rolls <= 27, name="constraint_8")

# 9. lightbulbs usefulness rating + rubber_gloves usefulness rating <= 37
model.addConstr(r0['lightbulbs']*lightbulbs + r0['rubber_gloves']*rubber_gloves <= 37, name="constraint_9")

# 10. lightbulbs usefulness rating + rubber_gloves usefulness rating + paper_towel_rolls usefulness rating <= 51
model.addConstr(r0['lightbulbs']*lightbulbs + r0['rubber_gloves']*rubber_gloves + r0['paper_towel_rolls']*paper_towel_rolls <= 51, name="constraint_10")

# 11. lightbulbs sustainability score + paper_towel_rolls sustainability score <= 80
model.addConstr(r1['lightbulbs']*lightbulbs + r1['paper_towel_rolls']*paper_towel_rolls <= 80, name="constraint_11")

# 12. lightbulbs sustainability score + rubber_gloves sustainability score <= 48
model.addConstr(r1['lightbulbs']*lightbulbs + r1['rubber_gloves']*rubber_gloves <= 48, name="constraint_12")

# 13. lightbulbs sustainability score + rubber_gloves sustainability score + paper_towel_rolls sustainability score <= 74
model.addConstr(r1['lightbulbs']*lightbulbs + r1['rubber_gloves']*rubber_gloves + r1['paper_towel_rolls']*paper_towel_rolls <= 74, name="constraint_13")

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Lightbulbs: ", lightbulbs.varValue)
    print("Rubber Gloves: ", rubber_gloves.varValue)
    print("Paper Towel Rolls: ", paper_towel_rolls.varValue)
else:
    print("The model is infeasible")
