
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
vitamin_a = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_a")
fat = m.addVar(vtype=gp.GRB.INTEGER, name="fat")
fiber = m.addVar(vtype=gp.GRB.CONTINUOUS, name="fiber")

# Set objective function
m.setObjective(1.97 * vitamin_a**2 + 1.23 * fiber**2 + 5.84 * fiber, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14 * vitamin_a <= 218, "muscle_growth_vitamin_a")  # Resource constraint for vitamin A
m.addConstr(20 * vitamin_a <= 88, "cardio_support_vitamin_a")  # Resource constraint for vitamin A
m.addConstr(17 * fat <= 218, "muscle_growth_fat")  # Resource constraint for fat
m.addConstr(8 * fat <= 88, "cardio_support_fat")  # Resource constraint for fat
m.addConstr(15 * fiber <= 218, "muscle_growth_fiber")  # Resource constraint for fiber
m.addConstr(19 * fiber <= 88, "cardio_support_fiber")  # Resource constraint for fiber

m.addConstr(14 * vitamin_a + 17 * fat >= 54, "muscle_growth_vitamin_a_fat")
m.addConstr(14 * vitamin_a + 15 * fiber >= 26, "muscle_growth_vitamin_a_fiber")
m.addConstr(14 * vitamin_a + 17 * fat + 15 * fiber >= 44, "muscle_growth_all")
m.addConstr(14 * vitamin_a + 15 * fiber <= 178, "muscle_growth_vitamin_a_fiber_max")
m.addConstr(17 * fat + 15 * fiber <= 132, "muscle_growth_fat_fiber_max")
m.addConstr(14 * vitamin_a + 17 * fat + 15 * fiber <= 152, "muscle_growth_all_max")
m.addConstr(14 * vitamin_a + 17 * fat + 15 * fiber <= 152, "muscle_growth_all_max2") # Duplicate constraint

m.addConstr(20 * vitamin_a + 8 * fat <= 78, "cardio_support_vitamin_a_fat")
m.addConstr(8 * fat**2 + 19 * fiber**2 <= 56, "cardio_support_fat_fiber") # Note: squared terms
m.addConstr(20 * vitamin_a + 8 * fat + 19 * fiber <= 56, "cardio_support_all")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vitamin_a:', vitamin_a.x)
    print('fat:', fat.x)
    print('fiber:', fiber.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

