
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
milligrams_vitamin_A = m.addVar(name="milligrams_vitamin_A", vtype=gp.GRB.INTEGER)
grams_fat = m.addVar(name="grams_fat", vtype=gp.GRB.INTEGER)
grams_fiber = m.addVar(name="grams_fiber")

# Objective function
m.setObjective(1.97 * milligrams_vitamin_A**2 + 1.23 * grams_fiber**2 + 5.84 * grams_fiber, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(milligrams_vitamin_A == 14, name="muscle_growth_index_vitamin_A")
m.addConstr(20 * milligrams_vitamin_A <= 88, name="cardiovascular_support_index_vitamin_A")
m.addConstr(17 * grams_fat <= 218, name="muscle_growth_index_fat")
m.addConstr(8 * grams_fat <= 88, name="cardiovascular_support_index_fat")
m.addConstr(15 * grams_fiber <= 218, name="muscle_growth_index_fiber")
m.addConstr(19 * grams_fiber <= 88, name="cardiovascular_support_index_fiber")

m.addConstr(14 * milligrams_vitamin_A + 17 * grams_fat >= 54, name="combined_muscle_growth_index_vitamin_A_fat")
m.addConstr(14 * milligrams_vitamin_A + 15 * grams_fiber >= 26, name="combined_muscle_growth_index_vitamin_A_fiber")
m.addConstr(14 * milligrams_vitamin_A + 17 * grams_fat + 15 * grams_fiber >= 44, name="combined_muscle_growth_index_all")
m.addConstr(14 * milligrams_vitamin_A + 15 * grams_fiber <= 178, name="combined_muscle_growth_index_vitamin_A_fiber_upper")
m.addConstr(17 * grams_fat + 15 * grams_fiber <= 132, name="combined_muscle_growth_index_fat_fiber")
m.addConstr(14 * milligrams_vitamin_A + 17 * grams_fat + 15 * grams_fiber <= 152, name="combined_muscle_growth_index_all_upper")

m.addConstr(20 * milligrams_vitamin_A + 8 * grams_fat <= 78, name="combined_cardiovascular_support_index_vitamin_A_fat")
m.addConstr(8 * grams_fat**2 + 19 * grams_fiber**2 <= 56, name="combined_cardiovascular_support_index_fat_fiber")
m.addConstr(20 * milligrams_vitamin_A + 8 * grams_fat + 19 * grams_fiber <= 56, name="combined_cardiovascular_support_index_all")

# Optimize the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of Vitamin A: {milligrams_vitamin_A.varValue}")
    print(f"Grams of Fat: {grams_fat.varValue}")
    print(f"Grams of Fiber: {grams_fiber.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
