
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
headsets = m.addVar(vtype=gp.GRB.INTEGER, name="headsets")
rubber_bands = m.addVar(vtype=gp.GRB.INTEGER, name="rubber_bands")
planners = m.addVar(vtype=gp.GRB.INTEGER, name="planners")
hole_punches = m.addVar(vtype=gp.GRB.INTEGER, name="hole_punches")

# Set objective function
m.setObjective(2 * headsets + 3 * rubber_bands + 5 * planners + 7 * hole_punches, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.5 * headsets + 0.12 * planners + 2.75 * hole_punches >= 45, "c1")
m.addConstr(0.5 * headsets + 2.54 * rubber_bands + 0.12 * planners >= 45, "c2")
m.addConstr(0.5 * headsets + 0.12 * planners + 2.75 * hole_punches >= 36, "c3")
m.addConstr(0.5 * headsets + 2.54 * rubber_bands + 0.12 * planners >= 36, "c4")

m.addConstr(1.49 * headsets + 0.16 * rubber_bands >= 39, "c5")
m.addConstr(0.16 * rubber_bands + 0.33 * planners >= 54, "c6")

m.addConstr(0.5 * headsets + 2.54 * rubber_bands <= 164, "c7")
m.addConstr(2.54 * rubber_bands + 0.12 * planners <= 104, "c8")
m.addConstr(0.5 * headsets + 0.12 * planners <= 101, "c9")
m.addConstr(2.54 * rubber_bands + 2.75 * hole_punches <= 92, "c10")

m.addConstr(0.5 * headsets + 2.54 * rubber_bands + 0.12 * planners + 2.75 * hole_punches <= 92, "c11")

m.addConstr(0.16 * rubber_bands + 0.33 * planners <= 177, "c12")
m.addConstr(1.49 * headsets + 0.33 * planners <= 190, "c13")
m.addConstr(0.33 * planners + 2.73 * hole_punches <= 85, "c14")
m.addConstr(1.49 * headsets + 0.16 * rubber_bands + 0.33 * planners + 2.73 * hole_punches <= 85, "c15")


m.addConstr(0.5 * headsets + 2.54 * rubber_bands + 0.12 * planners + 2.75 * hole_punches <= 222, "storage_limit") # r0
m.addConstr(1.49 * headsets + 0.16 * rubber_bands + 0.33 * planners + 2.73 * hole_punches <= 231, "weight_limit") # r1


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('headsets:', headsets.x)
    print('rubber_bands:', rubber_bands.x)
    print('planners:', planners.x)
    print('hole_punches:', hole_punches.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

