
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    headsets = model.addVar(name="headsets", vtype=gurobi.GRB.INTEGER)
    rubber_bands = model.addVar(name="rubber_bands", vtype=gurobi.GRB.INTEGER)
    planners = model.addVar(name="planners", vtype=gurobi.GRB.INTEGER)
    hole_punches = model.addVar(name="hole_punches", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(2 * headsets + 3 * rubber_bands + 5 * planners + 7 * hole_punches, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(0.5 * headsets + 2.54 * rubber_bands + 0.12 * planners + 2.75 * hole_punches <= 222)
    model.addConstr(1.49 * headsets + 0.16 * rubber_bands + 0.33 * planners + 2.73 * hole_punches <= 231)
    model.addConstr(0.5 * headsets + 0.12 * planners + 2.75 * hole_punches >= 45)
    model.addConstr(0.5 * headsets + 2.54 * rubber_bands + 0.12 * planners >= 45)
    model.addConstr(0.5 * headsets + 0.12 * planners + 2.75 * hole_punches >= 36)
    model.addConstr(0.5 * headsets + 2.54 * rubber_bands + 0.12 * planners >= 36)
    model.addConstr(1.49 * headsets + 0.16 * rubber_bands >= 39)
    model.addConstr(0.16 * rubber_bands + 0.33 * planners >= 54)
    model.addConstr(0.5 * headsets + 2.54 * rubber_bands <= 164)
    model.addConstr(2.54 * rubber_bands + 0.12 * planners <= 104)
    model.addConstr(0.5 * headsets + 0.12 * planners <= 101)
    model.addConstr(2.54 * rubber_bands + 2.75 * hole_punches <= 92)
    model.addConstr(0.5 * headsets + 2.54 * rubber_bands + 0.12 * planners + 2.75 * hole_punches <= 92)
    model.addConstr(0.16 * rubber_bands + 0.33 * planners <= 177)
    model.addConstr(1.49 * headsets + 0.33 * planners <= 190)
    model.addConstr(0.33 * planners + 2.73 * hole_punches <= 85)
    model.addConstr(1.49 * headsets + 0.16 * rubber_bands + 0.33 * planners + 2.73 * hole_punches <= 85)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Headsets: {headsets.varValue}")
        print(f"Rubber Bands: {rubber_bands.varValue}")
        print(f"Planners: {planners.varValue}")
        print(f"Hole Punches: {hole_punches.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
