
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
milkshakes = m.addVar(lb=0, name="milkshakes")
oranges = m.addVar(lb=0, name="oranges")
pizza = m.addVar(lb=0, name="pizza")
chicken = m.addVar(lb=0, name="chicken")

# Set objective function
m.setObjective(6.35 * milkshakes + 7.44 * oranges + 2.49 * pizza + 7.43 * chicken, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * milkshakes + 5 * pizza >= 8, "protein_constr1")
m.addConstr(1 * oranges + 5 * pizza >= 10, "protein_constr2")
m.addConstr(5 * pizza + 5 * chicken >= 20, "protein_constr3")
m.addConstr(4 * milkshakes + 5 * pizza + 5 * chicken >= 14, "protein_constr4")
m.addConstr(1 * oranges + 5 * chicken >= 15, "iron_constr1")
m.addConstr(2 * milkshakes + 2 * pizza >= 6, "iron_constr2")
m.addConstr(2 * pizza + 5 * chicken >= 5, "iron_constr3")
m.addConstr(1 * oranges + 2 * pizza >= 8, "iron_constr4")
m.addConstr(2 * milkshakes + 1 * oranges >= 12, "iron_constr5")
m.addConstr(1 * oranges + 5 * chicken <= 52, "protein_constr5")
m.addConstr(1 * oranges + 5 * pizza <= 73, "protein_constr6")
m.addConstr(4 * milkshakes + 5 * pizza <= 78, "protein_constr7")
m.addConstr(4 * milkshakes + 5 * pizza + 5 * chicken <= 54, "protein_constr8")
m.addConstr(4 * milkshakes + 1 * oranges + 5 * pizza + 5 * chicken <= 54, "protein_constr9")
m.addConstr(3 * pizza + 4 * chicken <= 79, "calcium_constr1")
m.addConstr(5 * oranges + 3 * pizza <= 61, "calcium_constr2")
m.addConstr(3 * milkshakes + 4 * chicken <= 78, "calcium_constr3")
m.addConstr(3 * milkshakes + 3 * pizza <= 38, "calcium_constr4")
m.addConstr(3 * milkshakes + 5 * oranges <= 61, "calcium_constr5")
m.addConstr(3 * milkshakes + 5 * oranges + 3 * pizza + 4 * chicken <= 61, "calcium_constr6")
m.addConstr(2 * milkshakes + 2 * pizza <= 27, "iron_constr6")
m.addConstr(2 * milkshakes + 1 * oranges <= 66, "iron_constr7")
m.addConstr(2 * pizza + 5 * chicken <= 37, "iron_constr8")
m.addConstr(1 * oranges + 2 * pizza <= 59, "iron_constr9")
m.addConstr(1 * oranges + 5 * chicken <= 62, "iron_constr10")
m.addConstr(2 * milkshakes + 1 * oranges + 5 * chicken <= 49, "iron_constr11")
m.addConstr(2 * milkshakes + 2 * pizza + 5 * chicken <= 40, "iron_constr12")
m.addConstr(2 * milkshakes + 1 * oranges + 2 * pizza + 5 * chicken <= 40, "iron_constr13")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Objective Value:', m.objVal)
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

