
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_c = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_c")
vitamin_b1 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b1")
vitamin_b6 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b6")
zinc = m.addVar(vtype=gp.GRB.INTEGER, name="zinc")

# Set objective function
m.setObjective(3 * vitamin_c + 1 * vitamin_b1 + 9 * vitamin_b6 + 9 * zinc, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(7 * vitamin_c + 1 * vitamin_b1 >= 26, "c1")
m.addConstr(7 * vitamin_c + 7 * zinc >= 38, "c2")
m.addConstr(7 * vitamin_c + 1 * vitamin_b1 + 8 * vitamin_b6 + 7 * zinc >= 38, "c3")
m.addConstr(11 * vitamin_b6 + 3 * zinc >= 22, "c4")
m.addConstr(8 * vitamin_c + 6 * vitamin_b1 >= 23, "c5")
m.addConstr(6 * vitamin_b1 + 11 * vitamin_b6 + 3 * zinc >= 21, "c6")
m.addConstr(8 * vitamin_c + 6 * vitamin_b1 + 3 * zinc >= 21, "c7")
m.addConstr(8 * vitamin_c + 11 * vitamin_b6 + 3 * zinc >= 21, "c8")
m.addConstr(6 * vitamin_b1 + 11 * vitamin_b6 + 3 * zinc >= 20, "c9")
m.addConstr(8 * vitamin_c + 6 * vitamin_b1 + 3 * zinc >= 20, "c10")
m.addConstr(8 * vitamin_c + 11 * vitamin_b6 + 3 * zinc >= 20, "c11")
m.addConstr(6 * vitamin_b1 + 11 * vitamin_b6 + 3 * zinc >= 12, "c12")
m.addConstr(8 * vitamin_c + 6 * vitamin_b1 + 3 * zinc >= 12, "c13")
m.addConstr(8 * vitamin_c + 11 * vitamin_b6 + 3 * zinc >= 12, "c14")
m.addConstr(8 * vitamin_c + 6 * vitamin_b1 + 11 * vitamin_b6 + 3 * zinc >= 12, "c15")
m.addConstr(6 * vitamin_b1 + 11 * vitamin_b6 >= 18, "c16")
m.addConstr(8 * vitamin_c + 11 * vitamin_b6 >= 21, "c17")
m.addConstr(11 * vitamin_b6 + 7 * zinc >= 33, "c18")
m.addConstr(8 * vitamin_c + 6 * vitamin_b1 + 11 * vitamin_b6 + 7 * zinc >= 33, "c19")
m.addConstr(1 * vitamin_c - 8 * vitamin_b1 >= 0, "c20")
m.addConstr(7 * vitamin_c + 7 * zinc <= 61, "c21")
m.addConstr(7 * vitamin_c + 8 * vitamin_b6 <= 133, "c22")
m.addConstr(8 * vitamin_b6 + 7 * zinc <= 89, "c23")
m.addConstr(8 * vitamin_c + 3 * zinc <= 41, "c24")
m.addConstr(8 * vitamin_c + 6 * vitamin_b1 <= 39, "c25")
m.addConstr(6 * vitamin_b1 + 11 * vitamin_b6 <= 89, "c26")
m.addConstr(8 * vitamin_c + 11 * vitamin_b6 + 3 * zinc <= 24, "c27")
m.addConstr(6 * vitamin_b1 + 11 * vitamin_b6 + 7 * zinc <= 92, "c28")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

